package forms;

import classes.Individuo;
import classes.Heuristica;
import classes.Individuos;
import classes.MetodoBuscaLocal;
import classes.Resultados;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/**
 * Formulario responsável pela importação e otimização com uso de meta-heuristica
 * @author Marcelo Otone
 */
public class frmMain extends javax.swing.JFrame {

    private DefaultListModel lista = new DefaultListModel();
    //declarando variáveis e listas globais
    private static double[][] distanciaEuclidianas; //Matriz com as distancias euclidianas entre as ups
    private static final ArrayList<ArrayList<double[]>> melhorResultado //Resultados obtidos
            = new ArrayList<ArrayList<double[]>>();
    ArrayList<Individuo> listaIndividuo = new ArrayList<Individuo>();
    private String caminho;
    private ArrayList resultados;
    private ArrayList relatorio;
    private double totalVolume;
    private double totalRenda;
    private int numPatios;
    DecimalFormat df = new DecimalFormat("###,##0.00");
    
    public frmMain() {
        initComponents();
        this.setLocationRelativeTo(null);
        resultados = new ArrayList(); //arraylist utilizado para recuperar as informações de resultado das heurísticas 
        relatorio = new ArrayList(); //arraylist utilizado para recuperar o relatório de soluções ótimas
        jlQuantidadeIteracoesSA.setVisible(false);
        jtxtQuantidadeIteracoesSA.setVisible(false);
        caminho = new File(".").getAbsolutePath();
        totalVolume = 0;
        totalRenda = 0;
        numPatios = 0;
        buttonGroup1.add(jRBPrimeiraMellhora);
        buttonGroup1.add(jRBMelhorMelhora);
    }
    
    //<editor-fold defaultstate="collapsed" desc="Get de componentes">
    public javax.swing.JPanel getjPanelGraf() {
        return jPanelGraf;
    }
    //</editor-fold>
    
    @SuppressWarnings("unchecked")
    
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jFrame1 = new javax.swing.JFrame();
        buttonGroup1 = new javax.swing.ButtonGroup();
        jTabbedPane2 = new javax.swing.JTabbedPane();
        jPanel10 = new javax.swing.JPanel();
        jPanel7 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jtxtArquivo = new javax.swing.JTextField();
        jbAbrir = new javax.swing.JButton();
        jbImportar = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jlTotalRegistros = new javax.swing.JLabel();
        jlTotalVolume = new javax.swing.JLabel();
        jlTotalRenda = new javax.swing.JLabel();
        jPanel5 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jtxtFlexibilizacaoVolume = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jtxtFlexibilizacaoRenda = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        jtxtNumeroPatios = new javax.swing.JTextField();
        jLRestricaoVolume = new javax.swing.JLabel();
        jLRestricaoRenda = new javax.swing.JLabel();
        jLabel19 = new javax.swing.JLabel();
        jLabel20 = new javax.swing.JLabel();
        jPanel6 = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        jLabel13 = new javax.swing.JLabel();
        jtxtArquivoResultado = new javax.swing.JTextField();
        jbSelecionarArquivoResultado = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jpConstrutiva = new javax.swing.JPanel();
        jLabel11 = new javax.swing.JLabel();
        jtxtNumeroIteracoes = new javax.swing.JTextField();
        jBProcessarConstrutiva = new javax.swing.JButton();
        jLabel22 = new javax.swing.JLabel();
        jtxtNumeroTestesConstrutiva = new javax.swing.JTextField();
        jpsimulatedAnnealing = new javax.swing.JPanel();
        jLabel14 = new javax.swing.JLabel();
        jLabel15 = new javax.swing.JLabel();
        jtxtIteracoesVizinhanca = new javax.swing.JTextField();
        jLabel16 = new javax.swing.JLabel();
        jtxtTxResfriamento = new javax.swing.JTextField();
        jLabel17 = new javax.swing.JLabel();
        jtxtTempInicial = new javax.swing.JTextField();
        jLabel18 = new javax.swing.JLabel();
        jtxtTempCongelamento = new javax.swing.JTextField();
        jBProcessarSA = new javax.swing.JButton();
        jCBConstrutivaInicial = new javax.swing.JCheckBox();
        jlQuantidadeIteracoesSA = new javax.swing.JLabel();
        jtxtQuantidadeIteracoesSA = new javax.swing.JTextField();
        jLabel21 = new javax.swing.JLabel();
        jtxtPesoPenalizacaoSA = new javax.swing.JTextField();
        jLabel23 = new javax.swing.JLabel();
        jtxtNumeroTestesSA = new javax.swing.JTextField();
        jPGRASP = new javax.swing.JPanel();
        jLabel25 = new javax.swing.JLabel();
        jtxtNumeroIteracoesGRASP = new javax.swing.JTextField();
        jLabel26 = new javax.swing.JLabel();
        jtxtNumeroTestesGRASP = new javax.swing.JTextField();
        jBProcessarGRASP = new javax.swing.JButton();
        jLabel28 = new javax.swing.JLabel();
        jLabel27 = new javax.swing.JLabel();
        jtxtLRCGRASP = new javax.swing.JTextField();
        jRBPrimeiraMellhora = new javax.swing.JRadioButton();
        jRBMelhorMelhora = new javax.swing.JRadioButton();
        jLabel29 = new javax.swing.JLabel();
        jtxtPesoPenalizacaoGRASP = new javax.swing.JTextField();
        jPanel9 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTAResultados = new javax.swing.JTextArea();
        jLProgresso = new javax.swing.JLabel();
        jPanel11 = new javax.swing.JPanel();
        jPanelGraf = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        JLCentrais = new javax.swing.JList<>();
        jtxtCentral = new javax.swing.JTextField();
        jBAdicionar = new javax.swing.JButton();
        jLabel24 = new javax.swing.JLabel();
        jBLimpar = new javax.swing.JButton();
        jBGerarGrafico = new javax.swing.JButton();
        jPanel8 = new javax.swing.JPanel();
        jLabel12 = new javax.swing.JLabel();

        javax.swing.GroupLayout jFrame1Layout = new javax.swing.GroupLayout(jFrame1.getContentPane());
        jFrame1.getContentPane().setLayout(jFrame1Layout);
        jFrame1Layout.setHorizontalGroup(
            jFrame1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        jFrame1Layout.setVerticalGroup(
            jFrame1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("SOFIA - Simulation and Optimization in Forest Application");

        jLabel1.setText("Arquivo:");

        jtxtArquivo.setName("jtxtArquivo"); // NOI18N

        jbAbrir.setText("Abrir");
        jbAbrir.setName("jbAbrir"); // NOI18N
        jbAbrir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbAbrirActionPerformed(evt);
            }
        });

        jbImportar.setText("Importar");
        jbImportar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbImportarActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel7Layout = new javax.swing.GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addComponent(jtxtArquivo, javax.swing.GroupLayout.PREFERRED_SIZE, 329, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jbAbrir, javax.swing.GroupLayout.PREFERRED_SIZE, 77, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jbImportar)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel7Layout.setVerticalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jtxtArquivo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jbAbrir)
                    .addComponent(jbImportar))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLabel5.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel5.setText("Resumo dos Dados:");

        jPanel1.setBackground(new java.awt.Color(153, 153, 153));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 839, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 4, Short.MAX_VALUE)
        );

        jLabel6.setText("Nº Total de elementos da Amostra");

        jLabel7.setText("Volume Total (m3)");

        jLabel8.setText("Renda Total ($)");

        jlTotalRegistros.setText("0");

        jlTotalVolume.setText("0,00");

        jlTotalRenda.setText("0,00");

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel6)
                            .addComponent(jlTotalRegistros))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel7)
                            .addComponent(jlTotalVolume))
                        .addGap(99, 99, 99)
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jlTotalRenda)
                            .addComponent(jLabel8))
                        .addGap(136, 136, 136))
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel5))
                        .addGap(0, 0, Short.MAX_VALUE))))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addComponent(jLabel5)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(jLabel7)
                    .addComponent(jLabel8))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jlTotalRegistros)
                    .addComponent(jlTotalVolume)
                    .addComponent(jlTotalRenda))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLabel2.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel2.setText("Restrições (Regulação da produção):");

        jPanel2.setBackground(new java.awt.Color(153, 153, 153));

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 842, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 5, Short.MAX_VALUE)
        );

        jLabel3.setText("Restrição de Volume:");

        jtxtFlexibilizacaoVolume.setName("jtxtArquivo"); // NOI18N

        jLabel4.setText("Flexibilização Renda (%):");

        jtxtFlexibilizacaoRenda.setToolTipText("");
        jtxtFlexibilizacaoRenda.setName("jtxtArquivo"); // NOI18N

        jLabel9.setText("Número de UPs:");

        jtxtNumeroPatios.setName("jtxtArquivo"); // NOI18N
        jtxtNumeroPatios.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jtxtNumeroPatiosFocusLost(evt);
            }
        });

        jLRestricaoVolume.setForeground(new java.awt.Color(0, 0, 153));
        jLRestricaoVolume.setText("Volume alvo");

        jLRestricaoRenda.setForeground(new java.awt.Color(0, 0, 153));
        jLRestricaoRenda.setText("Renda alvo");

        jLabel19.setText("Flexibilização Volume (%):");
        jLabel19.setToolTipText("");

        jLabel20.setText("Restrição de Renda:");

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2)
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel9)
                            .addComponent(jtxtNumeroPatios, javax.swing.GroupLayout.PREFERRED_SIZE, 112, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(22, 22, 22)
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel3)
                            .addComponent(jLRestricaoVolume))
                        .addGap(14, 14, 14)
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel19)
                            .addComponent(jtxtFlexibilizacaoVolume, javax.swing.GroupLayout.PREFERRED_SIZE, 63, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(69, 69, 69)
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLRestricaoRenda)
                            .addComponent(jLabel20))
                        .addGap(77, 77, 77)
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jtxtFlexibilizacaoRenda, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel4))))
                .addContainerGap(31, Short.MAX_VALUE))
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addComponent(jLabel9)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jtxtNumeroPatios, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLRestricaoVolume)))
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel3)
                            .addComponent(jLabel19)
                            .addComponent(jLabel4))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jtxtFlexibilizacaoVolume, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addComponent(jLabel20)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jtxtFlexibilizacaoRenda, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLRestricaoRenda))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLabel10.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel10.setText("Configurações:");

        jPanel3.setBackground(new java.awt.Color(153, 153, 153));

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 842, Short.MAX_VALUE)
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 5, Short.MAX_VALUE)
        );

        jLabel13.setText("Arquivo de resultado:");

        jbSelecionarArquivoResultado.setText("Selecionar");
        jbSelecionarArquivoResultado.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbSelecionarArquivoResultadoActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel10)
                    .addComponent(jLabel13)
                    .addGroup(jPanel6Layout.createSequentialGroup()
                        .addComponent(jtxtArquivoResultado, javax.swing.GroupLayout.PREFERRED_SIZE, 353, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jbSelecionarArquivoResultado)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addComponent(jLabel10)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel13)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jtxtArquivoResultado, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jbSelecionarArquivoResultado))
                .addGap(0, 0, Short.MAX_VALUE))
        );

        jpConstrutiva.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(153, 153, 153)));

        jLabel11.setText("Número de iterações por instância:");

        jtxtNumeroIteracoes.setName("jtxtArquivo"); // NOI18N

        jBProcessarConstrutiva.setText("Processar");
        jBProcessarConstrutiva.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBProcessarConstrutivaActionPerformed(evt);
            }
        });

        jLabel22.setText("Número de testes por instância:");

        jtxtNumeroTestesConstrutiva.setText("1");

        javax.swing.GroupLayout jpConstrutivaLayout = new javax.swing.GroupLayout(jpConstrutiva);
        jpConstrutiva.setLayout(jpConstrutivaLayout);
        jpConstrutivaLayout.setHorizontalGroup(
            jpConstrutivaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jpConstrutivaLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jpConstrutivaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel11)
                    .addComponent(jtxtNumeroIteracoes, javax.swing.GroupLayout.PREFERRED_SIZE, 112, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel22)
                    .addComponent(jtxtNumeroTestesConstrutiva, javax.swing.GroupLayout.PREFERRED_SIZE, 114, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(657, Short.MAX_VALUE))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jpConstrutivaLayout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jBProcessarConstrutiva)
                .addGap(78, 78, 78))
        );
        jpConstrutivaLayout.setVerticalGroup(
            jpConstrutivaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jpConstrutivaLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel11)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jtxtNumeroIteracoes, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jLabel22)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jtxtNumeroTestesConstrutiva, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jBProcessarConstrutiva)
                .addContainerGap(39, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Heurística Construtiva", jpConstrutiva);

        jpsimulatedAnnealing.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(153, 153, 153)));

        jLabel14.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel14.setText("Calibração do SA");

        jLabel15.setText("Iterações de vizinhança:");

        jLabel16.setText("Taxa de resfriamento:");

        jLabel17.setText("Temperatura inicial:");

        jLabel18.setText("Temperatura de congelamento:");

        jBProcessarSA.setText("Processar");
        jBProcessarSA.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBProcessarSAActionPerformed(evt);
            }
        });

        jCBConstrutivaInicial.setText("Construtiva como solução inicial");
        jCBConstrutivaInicial.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCBConstrutivaInicialItemStateChanged(evt);
            }
        });

        jlQuantidadeIteracoesSA.setText("Quantidade de Iterações:");

        jLabel21.setText("Peso para a penalização:");

        jLabel23.setText("Número de testes por instância:");

        jtxtNumeroTestesSA.setText("1");

        javax.swing.GroupLayout jpsimulatedAnnealingLayout = new javax.swing.GroupLayout(jpsimulatedAnnealing);
        jpsimulatedAnnealing.setLayout(jpsimulatedAnnealingLayout);
        jpsimulatedAnnealingLayout.setHorizontalGroup(
            jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jpsimulatedAnnealingLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel14)
                    .addGroup(jpsimulatedAnnealingLayout.createSequentialGroup()
                        .addGroup(jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jLabel15, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jtxtIteracoesVizinhanca)
                            .addComponent(jLabel16)
                            .addComponent(jtxtTxResfriamento)
                            .addComponent(jLabel17)
                            .addComponent(jtxtTempInicial, javax.swing.GroupLayout.PREFERRED_SIZE, 118, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(58, 58, 58)
                        .addGroup(jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCBConstrutivaInicial)
                            .addGroup(jpsimulatedAnnealingLayout.createSequentialGroup()
                                .addGroup(jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel18)
                                    .addComponent(jtxtTempCongelamento, javax.swing.GroupLayout.PREFERRED_SIZE, 117, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jlQuantidadeIteracoesSA)
                                    .addComponent(jtxtQuantidadeIteracoesSA, javax.swing.GroupLayout.PREFERRED_SIZE, 124, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(102, 102, 102)
                                .addGroup(jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel23)
                                    .addComponent(jLabel21)
                                    .addComponent(jtxtPesoPenalizacaoSA, javax.swing.GroupLayout.PREFERRED_SIZE, 146, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addGroup(jpsimulatedAnnealingLayout.createSequentialGroup()
                                        .addComponent(jtxtNumeroTestesSA, javax.swing.GroupLayout.PREFERRED_SIZE, 145, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addGap(62, 62, 62)
                                        .addComponent(jBProcessarSA)))))))
                .addContainerGap(109, Short.MAX_VALUE))
        );
        jpsimulatedAnnealingLayout.setVerticalGroup(
            jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jpsimulatedAnnealingLayout.createSequentialGroup()
                .addComponent(jLabel14)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jpsimulatedAnnealingLayout.createSequentialGroup()
                        .addComponent(jLabel15)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jtxtIteracoesVizinhanca, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel16)
                        .addGap(1, 1, 1)
                        .addComponent(jtxtTxResfriamento, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel17)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jtxtTempInicial, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jBProcessarSA)))
                    .addGroup(jpsimulatedAnnealingLayout.createSequentialGroup()
                        .addGroup(jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel18)
                            .addComponent(jLabel21))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jtxtTempCongelamento, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jtxtPesoPenalizacaoSA, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jCBConstrutivaInicial)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jlQuantidadeIteracoesSA)
                            .addComponent(jLabel23))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jpsimulatedAnnealingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jtxtQuantidadeIteracoesSA, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jtxtNumeroTestesSA, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addGap(0, 32, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Simulated Annealing", jpsimulatedAnnealing);

        jPGRASP.setToolTipText("");

        jLabel25.setText("Número de iterações por instância:");

        jtxtNumeroIteracoesGRASP.setName("jtxtArquivo"); // NOI18N

        jLabel26.setText("Número de testes por instância:");

        jtxtNumeroTestesGRASP.setText("1");

        jBProcessarGRASP.setText("Processar");
        jBProcessarGRASP.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBProcessarGRASPActionPerformed(evt);
            }
        });

        jLabel28.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel28.setText("Deve ser maior que o número de pátios.");

        jLabel27.setText("Tamanho da lista restrita de candidatos (LRC):");

        jRBPrimeiraMellhora.setSelected(true);
        jRBPrimeiraMellhora.setText("Método da Primeira Melhora");

        jRBMelhorMelhora.setText("Método da Melhor Melhora");

        jLabel29.setText("Peso para penalização:");

        javax.swing.GroupLayout jPGRASPLayout = new javax.swing.GroupLayout(jPGRASP);
        jPGRASP.setLayout(jPGRASPLayout);
        jPGRASPLayout.setHorizontalGroup(
            jPGRASPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPGRASPLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPGRASPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPGRASPLayout.createSequentialGroup()
                        .addGroup(jPGRASPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel25)
                            .addComponent(jtxtNumeroIteracoesGRASP, javax.swing.GroupLayout.PREFERRED_SIZE, 112, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel27)
                            .addGroup(jPGRASPLayout.createSequentialGroup()
                                .addComponent(jtxtLRCGRASP, javax.swing.GroupLayout.PREFERRED_SIZE, 114, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jLabel28)))
                        .addGroup(jPGRASPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPGRASPLayout.createSequentialGroup()
                                .addGap(28, 28, 28)
                                .addGroup(jPGRASPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel29)
                                    .addComponent(jtxtPesoPenalizacaoGRASP, javax.swing.GroupLayout.PREFERRED_SIZE, 146, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPGRASPLayout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jRBPrimeiraMellhora)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jRBMelhorMelhora)
                                .addGap(211, 211, 211))))
                    .addGroup(jPGRASPLayout.createSequentialGroup()
                        .addComponent(jLabel26)
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(jPGRASPLayout.createSequentialGroup()
                        .addComponent(jtxtNumeroTestesGRASP, javax.swing.GroupLayout.PREFERRED_SIZE, 114, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jBProcessarGRASP)
                        .addGap(186, 186, 186))))
        );
        jPGRASPLayout.setVerticalGroup(
            jPGRASPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPGRASPLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPGRASPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPGRASPLayout.createSequentialGroup()
                        .addGroup(jPGRASPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(jPGRASPLayout.createSequentialGroup()
                                .addComponent(jLabel29)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jtxtPesoPenalizacaoGRASP, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPGRASPLayout.createSequentialGroup()
                                .addComponent(jLabel25)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jtxtNumeroIteracoesGRASP, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel27)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(jPGRASPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jtxtLRCGRASP, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jLabel28))))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel26)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPGRASPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jtxtNumeroTestesGRASP, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jBProcessarGRASP)))
                    .addGroup(jPGRASPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jRBPrimeiraMellhora)
                        .addComponent(jRBMelhorMelhora)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("GRASP", jPGRASP);

        jTAResultados.setColumns(20);
        jTAResultados.setRows(5);
        jScrollPane1.setViewportView(jTAResultados);

        jLProgresso.setText("Aguardando configuração");
        jLProgresso.setToolTipText("");

        javax.swing.GroupLayout jPanel9Layout = new javax.swing.GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel9Layout.createSequentialGroup()
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel9Layout.createSequentialGroup()
                        .addGap(20, 20, 20)
                        .addComponent(jLProgresso))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 837, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, Short.MAX_VALUE))
        );
        jPanel9Layout.setVerticalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel9Layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 47, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLProgresso)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout jPanel10Layout = new javax.swing.GroupLayout(jPanel10);
        jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(
            jPanel10Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel7, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(jPanel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(jPanel6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(jPanel10Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel10Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel9, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(jPanel10Layout.createSequentialGroup()
                        .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 841, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel10Layout.setVerticalGroup(
            jPanel10Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel10Layout.createSequentialGroup()
                .addComponent(jPanel7, javax.swing.GroupLayout.PREFERRED_SIZE, 61, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, 70, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 212, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(8, 8, 8)
                .addComponent(jPanel9, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        jTabbedPane2.addTab("Configurações para Otimização", jPanel10);

        jPanelGraf.setBackground(new java.awt.Color(255, 255, 255));
        jPanelGraf.setForeground(new java.awt.Color(255, 255, 255));
        jPanelGraf.setAutoscrolls(true);
        jPanelGraf.setPreferredSize(new java.awt.Dimension(600, 600));

        javax.swing.GroupLayout jPanelGrafLayout = new javax.swing.GroupLayout(jPanelGraf);
        jPanelGraf.setLayout(jPanelGrafLayout);
        jPanelGrafLayout.setHorizontalGroup(
            jPanelGrafLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 600, Short.MAX_VALUE)
        );
        jPanelGrafLayout.setVerticalGroup(
            jPanelGrafLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 600, Short.MAX_VALUE)
        );

        jScrollPane2.setViewportView(JLCentrais);

        jBAdicionar.setText("Adicionar");
        jBAdicionar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBAdicionarActionPerformed(evt);
            }
        });

        jLabel24.setText("Central:");

        jBLimpar.setText("Limpar");
        jBLimpar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBLimparActionPerformed(evt);
            }
        });

        jBGerarGrafico.setText("Gerar Gráfico");
        jBGerarGrafico.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBGerarGraficoActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel11Layout = new javax.swing.GroupLayout(jPanel11);
        jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(
            jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel11Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel11Layout.createSequentialGroup()
                        .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel11Layout.createSequentialGroup()
                                .addComponent(jBLimpar)
                                .addGap(0, 0, Short.MAX_VALUE))
                            .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 253, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jPanelGraf, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel11Layout.createSequentialGroup()
                        .addComponent(jLabel24)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jtxtCentral, javax.swing.GroupLayout.PREFERRED_SIZE, 124, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jBAdicionar)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jBGerarGrafico)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel11Layout.setVerticalGroup(
            jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel11Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jtxtCentral, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jBAdicionar)
                    .addComponent(jLabel24)
                    .addComponent(jBGerarGrafico))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel11Layout.createSequentialGroup()
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jBLimpar))
                    .addComponent(jPanelGraf, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jTabbedPane2.addTab("Gráfico da Floresta", jPanel11);

        jLabel12.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
        jLabel12.setText("SOFIA - Simulation and Optimization in Forest Application");

        javax.swing.GroupLayout jPanel8Layout = new javax.swing.GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabel12, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        jPanel8Layout.setVerticalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel8Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jLabel12)
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jTabbedPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 888, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jTabbedPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 676, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    //<editor-fold defaultstate="collapsed" desc="private void jbAbrirActionPerformed(java.awt.event.ActionEvent evt)">
    private void jbAbrirActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbAbrirActionPerformed
        JFileChooser abrir = new JFileChooser(caminho);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Arquivos TXT", "txt");
        abrir.setDialogTitle("Abrir arquivo de dados");
        abrir.setFileFilter(filter);
        int retorno = abrir.showOpenDialog(null);  
        if (retorno == JFileChooser.APPROVE_OPTION) {
            jtxtArquivo.setText(abrir.getSelectedFile().getAbsolutePath());
            caminho = abrir.getSelectedFile().getPath();
        }
    }//GEN-LAST:event_jbAbrirActionPerformed
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private void jbImportarActionPerformed(java.awt.event.ActionEvent evt)">
    private void jbImportarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbImportarActionPerformed
        // Evento responsável por acionar a importação dos dados
        if (jtxtArquivo.getText().trim().equals("")){
            JOptionPane.showMessageDialog(null, "Selecione um arquivo!", "Arquivo não selecionado", JOptionPane.ERROR_MESSAGE);
        }
        else {
            //importando os dados
            try {
                Individuos importacao = new Individuos();
                listaIndividuo = importacao.Importar(jtxtArquivo.getText().trim());
                distanciaEuclidianas = new double[listaIndividuo.size()][listaIndividuo.size()];
                
                for (Individuo individuo: listaIndividuo) {
                    totalVolume += individuo.getVolume();
                    totalRenda += individuo.getRenda();
                }
                
                jlTotalRegistros.setText(String.valueOf(listaIndividuo.size()));
                jlTotalVolume.setText(df.format(totalVolume));
                jlTotalRenda.setText(df.format(totalRenda));
                
                //plotando a floresta
                plotarDadosInicial();
                
                //definindo a matriz de euclidiana
                CalculaDistancia(listaIndividuo);
                
                JOptionPane.showMessageDialog(null, "Importação realizada com sucesso!\nTotal de: "+String.valueOf(listaIndividuo.size())+
                        " registros", "Sucesso", JOptionPane.OK_OPTION);
                
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Erro ao ler o arquivo!", "Erro", JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_jbImportarActionPerformed
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private void jBProcessarActionPerformed(java.awt.event.ActionEvent evt)">
    private void jBProcessarConstrutivaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBProcessarConstrutivaActionPerformed
        if (listaIndividuo.size() > 0) {
            if (!jtxtNumeroPatios.getText().trim().isEmpty()) {
                if (!jtxtArquivoResultado.getText().trim().isEmpty()) {
                    if (!jtxtNumeroIteracoes.getText().trim().isEmpty()) {
                        if (!jtxtNumeroTestesConstrutiva.getText().trim().isEmpty()) {
                            new Thread() {
                                @Override
                                public void run() {                        
                                    try {
                                        jTAResultados.setText("");
                                        int numTestes = Integer.parseInt(jtxtNumeroTestesConstrutiva.getText());
                                        for (int i=1; i<=numTestes; i++) {
                                            ProcessaHeuristica(1, i, !jtxtFlexibilizacaoVolume.getText().isEmpty(), !jtxtFlexibilizacaoRenda.getText().isEmpty());                                
                                        }
                                    } catch (InterruptedException ex) {
                                        Logger.getLogger(frmMain.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            }.start();                            
                        }
                        else {
                            JOptionPane.showMessageDialog(null, "Informe o número testes para a heurística construtiva.", "Erro", JOptionPane.ERROR_MESSAGE);
                            jtxtNumeroTestesConstrutiva.grabFocus();
                        }
                    }
                    else {
                        JOptionPane.showMessageDialog(null, "Informe o número de iterações.", "Erro", JOptionPane.ERROR_MESSAGE);
                        jtxtNumeroIteracoes.grabFocus();
                    }
                }
                else {
                    JOptionPane.showMessageDialog(null, "Selecione o arquivo para salvar os resultados", "Erro", JOptionPane.ERROR_MESSAGE);
                    jtxtArquivoResultado.grabFocus(); 
                }                
            }
            else {
                JOptionPane.showMessageDialog(null, "Informe o número de pátios.", "Erro", JOptionPane.ERROR_MESSAGE);
                jtxtNumeroPatios.grabFocus();               
            }
        }
        else
            JOptionPane.showMessageDialog(null, "Um arquivo deve ser importado!", "Erro", JOptionPane.ERROR_MESSAGE);

    }//GEN-LAST:event_jBProcessarConstrutivaActionPerformed
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private void jBProcessarSAActionPerformed(java.awt.event.ActionEvent evt)">
    private void jBProcessarSAActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBProcessarSAActionPerformed
        if (listaIndividuo.size() > 0) {
            if (!jtxtNumeroPatios.getText().trim().isEmpty()) {
                if (!jtxtArquivoResultado.getText().trim().isEmpty()) {
                    if (!jtxtIteracoesVizinhanca.getText().trim().isEmpty()) {
                        if (!jtxtTxResfriamento.getText().trim().isEmpty()) {
                            if (!jtxtTempInicial.getText().trim().isEmpty()) {
                                if (!jtxtTempCongelamento.getText().trim().isEmpty()) {
                                    if (!jCBConstrutivaInicial.isSelected() || (jCBConstrutivaInicial.isSelected() && !jtxtQuantidadeIteracoesSA.getText().trim().isEmpty())) {
                                        if (!jtxtNumeroTestesSA.getText().trim().isEmpty()) {
                                            new Thread() {
                                                @Override
                                                public void run() {
                                                    try {
                                                        jTAResultados.setText("");
                                                        int numTestes = Integer.parseInt(jtxtNumeroTestesSA.getText());
                                                        for (int i=1; i<=numTestes; i++) {
                                                            ProcessaHeuristica(2, i, !jtxtFlexibilizacaoVolume.getText().isEmpty(), !jtxtFlexibilizacaoRenda.getText().isEmpty());    
                                                        }
                                                    } catch (InterruptedException ex) {
                                                        Logger.getLogger(frmMain.class.getName()).log(Level.SEVERE, null, ex);
                                                    }
                                                }
                                            }.start();                                            
                                        }
                                        else {
                                            JOptionPane.showMessageDialog(null, "Informe o número de testes para o SA.", "Erro", JOptionPane.ERROR_MESSAGE);
                                            jtxtNumeroTestesSA.grabFocus();
                                        }                                        
                                    }
                                    else {
                                        JOptionPane.showMessageDialog(null, "Informe a quantidade de iterações para a heurística construtiva como solução inicial.", "Erro", JOptionPane.ERROR_MESSAGE);
                                        jtxtQuantidadeIteracoesSA.grabFocus();
                                    }
                                }
                                else {
                                    JOptionPane.showMessageDialog(null, "Informe a temperatura de congelamento.", "Erro", JOptionPane.ERROR_MESSAGE);
                                    jtxtTempCongelamento.grabFocus();
                                }
                            }
                            else {
                                JOptionPane.showMessageDialog(null, "Informe a temperatura inicial.", "Erro", JOptionPane.ERROR_MESSAGE);
                                jtxtTempInicial.grabFocus();
                            }
                        }
                        else {
                            JOptionPane.showMessageDialog(null, "Informe a taxa de resfriamento.", "Erro", JOptionPane.ERROR_MESSAGE);
                            jtxtTxResfriamento.grabFocus();
                        }
                    }
                    else {
                        JOptionPane.showMessageDialog(null, "Informe o número de iterações de sondagem da vizinhança.", "Erro", JOptionPane.ERROR_MESSAGE);
                        jtxtIteracoesVizinhanca.grabFocus();
                    }
                }
                else {
                    JOptionPane.showMessageDialog(null, "Selecione o arquivo para salvar os resultados", "Erro", JOptionPane.ERROR_MESSAGE);
                    jtxtArquivoResultado.grabFocus(); 
                } 
            }
            else {
                JOptionPane.showMessageDialog(null, "Informe o número de pátios.", "Erro", JOptionPane.ERROR_MESSAGE);
                jtxtNumeroPatios.grabFocus();
            }
        }
        else
            JOptionPane.showMessageDialog(null, "Um arquivo deve ser importado!", "Erro", JOptionPane.ERROR_MESSAGE);
    }//GEN-LAST:event_jBProcessarSAActionPerformed
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private void jCBConstrutivaInicialItemStateChanged(java.awt.event.ItemEvent evt)">
    private void jCBConstrutivaInicialItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCBConstrutivaInicialItemStateChanged
        if (jCBConstrutivaInicial.isSelected()) {
            jlQuantidadeIteracoesSA.setVisible(true);
            jtxtQuantidadeIteracoesSA.setVisible(true);
        }
        else {
            jlQuantidadeIteracoesSA.setVisible(false);
            jtxtQuantidadeIteracoesSA.setVisible(false);
        }
    }//GEN-LAST:event_jCBConstrutivaInicialItemStateChanged
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private void jbSelecionarArquivoResultadoActionPerformed(java.awt.event.ItemEvent evt)">
    private void jbSelecionarArquivoResultadoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbSelecionarArquivoResultadoActionPerformed
        JFileChooser selecionar = new JFileChooser(caminho);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Arquivos TXT", "txt");
        selecionar.setDialogTitle("Selecionar arquivo de resultados");
        selecionar.setFileFilter(filter);
        int retorno = selecionar.showOpenDialog(null);  
        if (retorno == JFileChooser.APPROVE_OPTION) {
            jtxtArquivoResultado.setText(selecionar.getSelectedFile().toString());
            caminho = selecionar.getSelectedFile().getPath();
        }
    }//GEN-LAST:event_jbSelecionarArquivoResultadoActionPerformed
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private void jtxtNumeroPatiosFocusLost(java.awt.event.FocusEvent evt)">
    private void jtxtNumeroPatiosFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jtxtNumeroPatiosFocusLost
        if (!jtxtNumeroPatios.getText().trim().isEmpty()) {
            numPatios = Integer.parseInt(jtxtNumeroPatios.getText());
            jLRestricaoVolume.setText(df.format(totalVolume / numPatios));
            jLRestricaoRenda.setText(df.format(totalRenda / numPatios));
        }
    }//GEN-LAST:event_jtxtNumeroPatiosFocusLost
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private void jBLimparActionPerformed(java.awt.event.ActionEvent evt)">
    private void jBLimparActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBLimparActionPerformed
        // TODO add your handling code here:
        lista.clear();
        JLCentrais.setModel(lista);
    }//GEN-LAST:event_jBLimparActionPerformed
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private void jBAdicionarActionPerformed(java.awt.event.ActionEvent evt)">
    private void jBAdicionarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBAdicionarActionPerformed
        // TODO add your handling code here:
        if (!jtxtCentral.getText().isEmpty()) {
            lista.addElement(jtxtCentral.getText());
            JLCentrais.setModel(lista);
            jtxtCentral.setText("");
        }
        else
            JOptionPane.showMessageDialog(null, "Digite o número da central para adicionar!", "Erro", JOptionPane.ERROR_MESSAGE);            
    }//GEN-LAST:event_jBAdicionarActionPerformed
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private void jBGerarGraficoActionPerformed(java.awt.event.ActionEvent evt)">
    private void jBGerarGraficoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBGerarGraficoActionPerformed
        // TODO add your handling code here:
        if (listaIndividuo.size() > 0) {
            if (lista.size() > 0) {
                Resultados resultado = new Resultados();
                int res[] = new int[lista.size()];
                for (int i=0; i<lista.getSize(); i++) {
                    res[i] = Integer.parseInt(String.valueOf(lista.get(i)));
                }
                resultado.setSolucao(res);
                CarregaMelhorResultado(resultado);
                plotarDadosProcessados(resultado.getSolucao().length);
            }
            else
                JOptionPane.showMessageDialog(null, "As centrais devem ser especificadas!", "Erro", JOptionPane.ERROR_MESSAGE);    
        }
        else
            JOptionPane.showMessageDialog(null, "Um arquivo deve ser importado!", "Erro", JOptionPane.ERROR_MESSAGE);
    }//GEN-LAST:event_jBGerarGraficoActionPerformed
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private void jBProcessarGRASPActionPerformed(java.awt.event.ActionEvent evt)">
    private void jBProcessarGRASPActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBProcessarGRASPActionPerformed
        if (listaIndividuo.size() > 0) {
            if (!jtxtNumeroPatios.getText().trim().isEmpty()) {
                if (!jtxtArquivoResultado.getText().trim().isEmpty()) {
                    if (!jtxtNumeroIteracoesGRASP.getText().trim().isEmpty()) {
                        if (!jtxtLRCGRASP.getText().trim().isEmpty()) {
                            if (Integer.parseInt(jtxtLRCGRASP.getText().trim()) > Integer.parseInt(jtxtNumeroPatios.getText().trim())) {
                                if (!jtxtNumeroTestesGRASP.getText().trim().isEmpty()) {

                                    new Thread() {
                                        @Override
                                        public void run() {
                                            try {
                                                jTAResultados.setText("");
                                                int numTestes = Integer.parseInt(jtxtNumeroTestesGRASP.getText());
                                                for (int i=1; i<=numTestes; i++) {
                                                    ProcessaHeuristica(3, i, !jtxtFlexibilizacaoVolume.getText().isEmpty(), !jtxtFlexibilizacaoRenda.getText().isEmpty());    
                                                }
                                            } catch (InterruptedException ex) {
                                                Logger.getLogger(frmMain.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                        }
                                    }.start();

                                }
                                else {
                                    JOptionPane.showMessageDialog(null, "Informe o número de testes para o GRASP.", "Erro", JOptionPane.ERROR_MESSAGE);
                                    jtxtNumeroTestesGRASP.grabFocus();
                                }
                            }
                            else {
                                JOptionPane.showMessageDialog(null, "O tamanho da LRC deve ser maior que o número de pátios.", "Erro", JOptionPane.ERROR_MESSAGE);
                                jtxtLRCGRASP.grabFocus();
                            }
                        }
                        else {
                            JOptionPane.showMessageDialog(null, "Informe o tamanho da lista restrita de candidatos.", "Erro", JOptionPane.ERROR_MESSAGE);
                            jtxtLRCGRASP.grabFocus();
                        }
                    }
                    else {
                        JOptionPane.showMessageDialog(null, "Informe o número de iterações para o GRASP.", "Erro", JOptionPane.ERROR_MESSAGE);
                        jtxtNumeroIteracoesGRASP.grabFocus();
                    }
                }
                else {
                    JOptionPane.showMessageDialog(null, "Selecione o arquivo para salvar os resultados", "Erro", JOptionPane.ERROR_MESSAGE);
                    jtxtArquivoResultado.grabFocus(); 
                } 
            }
            else {
                JOptionPane.showMessageDialog(null, "Informe o número de pátios.", "Erro", JOptionPane.ERROR_MESSAGE);
                jtxtNumeroPatios.grabFocus();
            }
        }
        else
            JOptionPane.showMessageDialog(null, "Um arquivo deve ser importado!", "Erro", JOptionPane.ERROR_MESSAGE);        
    }//GEN-LAST:event_jBProcessarGRASPActionPerformed
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public void ProcessaHeuristica()">
    public void ProcessaHeuristica(int opcao, int teste, boolean restVolume, boolean restRenda) throws InterruptedException {
        //limpando

        long tempoInicio = System.currentTimeMillis();
        jLProgresso.setText("Aguarde - executando a heuristica do teste: " + Integer.toString(teste));
        int qtdePatios = Integer.parseInt(jtxtNumeroPatios.getText());  //obtendo a quantidade patios
        int qtdeIteracoes;
        Resultados melhorFO = new Resultados();

        Heuristica heuristica = new Heuristica(); //instanciando a classe de heuristicas
        //escolhendo a heurística
        switch (opcao) {
            case 1:
                //heuristica gulosa
                try {
                    qtdeIteracoes = Integer.parseInt(jtxtNumeroIteracoes.getText()); //obtendo a quantidade de iterações
                    
                    if (!restVolume && !restRenda)
                        melhorFO = heuristica.heuristicaConstrutiva(distanciaEuclidianas, qtdePatios, qtdeIteracoes);
                    else if (restVolume && !restRenda) {
                        double flexVolume = Double.parseDouble(jtxtFlexibilizacaoVolume.getText());
                        melhorFO = heuristica.heuristicaConstrutiva(distanciaEuclidianas, listaIndividuo, numPatios, qtdeIteracoes, 1, totalVolume, flexVolume);
                    }
                    else if (!restVolume && restRenda) {
                        double flexRenda = Double.parseDouble(jtxtFlexibilizacaoRenda.getText());
                        melhorFO = heuristica.heuristicaConstrutiva(distanciaEuclidianas, listaIndividuo, numPatios, qtdeIteracoes, 2, totalRenda, flexRenda);
                    }
                    else {
                        double flexVolume = Double.parseDouble(jtxtFlexibilizacaoVolume.getText());
                        double flexRenda = Double.parseDouble(jtxtFlexibilizacaoRenda.getText());
                        melhorFO = heuristica.heuristicaConstrutiva(distanciaEuclidianas, listaIndividuo, numPatios, qtdeIteracoes, totalVolume, flexVolume, totalRenda, flexRenda);
                    }
                } catch (Exception ex) {
                    Logger.getLogger(frmMain.class.getName()).log(Level.SEVERE, null, ex);
                }   break;
            case 2:
                try {
                    //Simulated annealing
                    Resultados solucaoInicial = new Resultados();
                    int aleatoria[] = new int[numPatios];                    
                    //solução inicial
                    if (jCBConstrutivaInicial.isSelected()) {
                        qtdeIteracoes = Integer.parseInt(jtxtQuantidadeIteracoesSA.getText()); //obtendo a quantidade de iterações
                        if (!restVolume && !restRenda)
                            solucaoInicial = heuristica.heuristicaConstrutiva(distanciaEuclidianas, qtdePatios, qtdeIteracoes);
                        else if (restVolume && !restRenda) {
                            double flexVolume = Double.parseDouble(jtxtFlexibilizacaoVolume.getText());
                            solucaoInicial = heuristica.heuristicaConstrutiva(distanciaEuclidianas, listaIndividuo, numPatios, qtdeIteracoes, 1, totalVolume, flexVolume);
                        }
                        else if (!restVolume && restRenda) {
                            double flexRenda = Double.parseDouble(jtxtFlexibilizacaoRenda.getText());
                            solucaoInicial = heuristica.heuristicaConstrutiva(distanciaEuclidianas, listaIndividuo, numPatios, qtdeIteracoes, 2, totalRenda, flexRenda);
                        }
                        else {
                            double flexVolume = Double.parseDouble(jtxtFlexibilizacaoVolume.getText());
                            double flexRenda = Double.parseDouble(jtxtFlexibilizacaoRenda.getText());
                            solucaoInicial = heuristica.heuristicaConstrutiva(distanciaEuclidianas, listaIndividuo, numPatios, qtdeIteracoes, totalVolume, flexVolume, totalRenda, flexRenda);
                        }
                    }
                    else {
                        //instanciando a classe random
                        Random gerador = new Random();
                        
                        int qtdeElementos = listaIndividuo.size();
                        for (int j=0; j<qtdePatios; j++) {
                            aleatoria[j] = gerador.nextInt(qtdeElementos)+1;
                        }
                        solucaoInicial.setSolucao(aleatoria);
                    }
                    
                    //calibrando parâmetros
                    qtdeIteracoes = Integer.parseInt(jtxtIteracoesVizinhanca.getText()); //obtendo a quantidade de iterações
                    double txResfriamento = Double.parseDouble(jtxtTxResfriamento.getText()); //obtendo a taxa de resfriamento
                    double tempInicial = Double.parseDouble(jtxtTempInicial.getText()); //obtendo a temperatura inicial
                    double tempCongelamento = Double.parseDouble(jtxtTempCongelamento.getText()); //obtendo a temperatura de congelamento
                    
                    if (!restVolume && !restRenda) {
                        melhorFO = heuristica.simulatedAnnealing(distanciaEuclidianas, qtdePatios, txResfriamento, qtdeIteracoes,
                                tempInicial, tempCongelamento, solucaoInicial.getSolucao());
                    }
                    else if (restVolume && !restRenda) {
                        double flexVolume = Double.parseDouble(jtxtFlexibilizacaoVolume.getText());
                        double penalizacao = Double.parseDouble(jtxtPesoPenalizacaoSA.getText());
                        melhorFO = heuristica.simulatedAnnealing(distanciaEuclidianas, listaIndividuo, numPatios, txResfriamento, qtdeIteracoes,
                                tempInicial, tempCongelamento, penalizacao, solucaoInicial.getSolucao(), 1, totalVolume, flexVolume);
                    }
                    else if (!restVolume && restRenda) {
                        double flexRenda = Double.parseDouble(jtxtFlexibilizacaoRenda.getText());
                        double penalizacao = Double.parseDouble(jtxtPesoPenalizacaoSA.getText());
                        melhorFO = heuristica.simulatedAnnealing(distanciaEuclidianas, listaIndividuo, numPatios, txResfriamento, qtdeIteracoes,
                                tempInicial, tempCongelamento, penalizacao, solucaoInicial.getSolucao(), 2, totalRenda, flexRenda);
                    }
                    else {
                        double flexVolume = Double.parseDouble(jtxtFlexibilizacaoVolume.getText());
                        double flexRenda = Double.parseDouble(jtxtFlexibilizacaoRenda.getText());
                        double penalizacao = Double.parseDouble(jtxtPesoPenalizacaoSA.getText());
                        melhorFO = heuristica.simulatedAnnealing(distanciaEuclidianas, listaIndividuo, numPatios, txResfriamento, qtdeIteracoes,
                                tempInicial, tempCongelamento, penalizacao, solucaoInicial.getSolucao(), totalVolume, flexVolume,
                                totalRenda, flexRenda);
                    }
                    
                } catch (Exception ex) {
                    Logger.getLogger(frmMain.class.getName()).log(Level.SEVERE, null, ex);
                }   break;
            case 3:
                //GRASP
                try {
                    qtdeIteracoes = Integer.parseInt(jtxtNumeroIteracoesGRASP.getText().trim()); //obtendo a quantidade de iterações
                    int LRC = Integer.parseInt(jtxtLRCGRASP.getText().trim());
                    
                    if (!restVolume && !restRenda) {
                        if (jRBPrimeiraMellhora.isSelected()) {
                            melhorFO = heuristica.GRASP(distanciaEuclidianas, listaIndividuo, qtdePatios, qtdeIteracoes, LRC, MetodoBuscaLocal.PrimeiraMelhora);
                        }
                        else {
                            melhorFO = heuristica.GRASP(distanciaEuclidianas, listaIndividuo, qtdePatios, qtdeIteracoes, LRC, MetodoBuscaLocal.MelhorMelhora);
                        }
                    }
                    else if (restVolume && !restRenda) {
                        double flexVolume = Double.parseDouble(jtxtFlexibilizacaoVolume.getText());
                        double penalizacao = Double.parseDouble(jtxtPesoPenalizacaoGRASP.getText());
                        if (jRBPrimeiraMellhora.isSelected()) {
                            melhorFO = heuristica.GRASP(distanciaEuclidianas, listaIndividuo, numPatios, qtdeIteracoes, LRC, MetodoBuscaLocal.PrimeiraMelhora, penalizacao, 1, totalVolume, flexVolume);
                        }
                        else {
                            melhorFO = heuristica.GRASP(distanciaEuclidianas, listaIndividuo, numPatios, qtdeIteracoes, LRC, MetodoBuscaLocal.MelhorMelhora, penalizacao, 1, totalVolume, flexVolume);
                        }
                    }
                    else if (!restVolume && restRenda) {
                        double flexRenda = Double.parseDouble(jtxtFlexibilizacaoRenda.getText());
                        double penalizacao = Double.parseDouble(jtxtPesoPenalizacaoGRASP.getText());
                        if (jRBPrimeiraMellhora.isSelected()) {
                            melhorFO = heuristica.GRASP(distanciaEuclidianas, listaIndividuo, numPatios, qtdeIteracoes, LRC, MetodoBuscaLocal.PrimeiraMelhora, penalizacao, 1, totalRenda, flexRenda);
                        }
                        else {
                            melhorFO = heuristica.GRASP(distanciaEuclidianas, listaIndividuo, numPatios, qtdeIteracoes, LRC, MetodoBuscaLocal.MelhorMelhora, penalizacao, 1, totalRenda, flexRenda);
                        }
                    }
                    else { 
                        double flexVolume = Double.parseDouble(jtxtFlexibilizacaoVolume.getText());
                        double flexRenda = Double.parseDouble(jtxtFlexibilizacaoRenda.getText());
                        double penalizacao = Double.parseDouble(jtxtPesoPenalizacaoGRASP.getText());
                        if (jRBPrimeiraMellhora.isSelected()) {
                            melhorFO = heuristica.GRASP(distanciaEuclidianas, listaIndividuo, numPatios, qtdeIteracoes, LRC, MetodoBuscaLocal.PrimeiraMelhora, penalizacao, totalVolume, flexVolume, totalRenda, flexRenda);
                        }
                        else {
                            melhorFO = heuristica.GRASP(distanciaEuclidianas, listaIndividuo, numPatios, qtdeIteracoes, LRC, MetodoBuscaLocal.MelhorMelhora, penalizacao, totalVolume, flexVolume, totalRenda, flexRenda);                            
                        }
                    }
                } catch (Exception ex) {
                    Logger.getLogger(frmMain.class.getName()).log(Level.SEVERE, null, ex);
                }   break;
            default:
                break;
        }
        
        long tempoFinal = System.currentTimeMillis() - tempoInicio;
        jTAResultados.append("Resultados salvos em: " + jtxtArquivoResultado.getText());
        jTAResultados.append("\nTempo de processamento: " + String.valueOf(tempoFinal) + " milisegundos");
        jTAResultados.append("\n");
        jLProgresso.setText("Plotando os dados");
        //carregando os individuos do melhor resultado
        
        CarregaMelhorResultado(melhorFO);
        //salvando o melhor resultado em arquivo
        SalvaMelhorResultado(melhorFO, opcao, teste, tempoFinal);

        //plotando resultado
        if (teste == 1)
            plotarDadosProcessados(numPatios);

        jLProgresso.setText("Concluído");
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private void CarregaMelhorResultado(ArrayList centrais)">
    private void CarregaMelhorResultado(Resultados resultados) {
        try {
            int total = listaIndividuo.size();
            melhorResultado.clear();

            //preenchendo as centrais
            for (Object valor: resultados.getSolucao()) {
                Individuo individuo = listaIndividuo.get(Integer.parseInt(String.valueOf(valor))-1);
                ArrayList<double[]> patios = new ArrayList<double[]>();
                double[] central = new double[3];
                central[0] = individuo.getCodIndividuo();
                central[1] = individuo.getPosX();
                central[2] = individuo.getPosY();
                patios.add(central);
                melhorResultado.add(patios);
            }
            
            for (int i=0; i<total; i++) {
                double distanciaMenor = 0;
                int melhorPatio = 0;
                
                for (int j = 0; j < resultados.getSolucao().length; j++) {
                    int individuo = Integer.parseInt(String.valueOf(resultados.getSolucao()[j]));

                    double distancia = distanciaEuclidianas[i][individuo-1];
                    if (distancia < distanciaMenor || j == 0) {
                        distanciaMenor = distancia;
                        melhorPatio = j;
                    }                        
                }

                //atribuindo individuo à central
                Individuo individuoInd = listaIndividuo.get(i);
                double[] individuo = new double[3];
                individuo[0] = individuoInd.getCodIndividuo();
                individuo[1] = individuoInd.getPosX();
                individuo[2] = individuoInd.getPosY();

                melhorResultado.get(melhorPatio).add(individuo);
            }
        } catch (Exception ex) {
            Logger.getLogger(frmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private void SalvaMelhorResultado()">
    private void SalvaMelhorResultado(Resultados resultados, int opcao, int teste, long tempo) {
        try {
            FileWriter arq = new FileWriter(jtxtArquivoResultado.getText()+ String.valueOf(teste) + ".txt");
            PrintWriter gravarArq = new PrintWriter(arq);
            double restVolume = totalVolume / numPatios;
            double restRenda = totalRenda / numPatios;
            double flexVolume = 0;
            double flexRenda = 0;

            gravarArq.printf("+-----------------------Informações de Entrada----------------------+%n");
            switch (opcao) {
                case 1:
                    gravarArq.printf("Heurística: Construtiva %n");
                    gravarArq.printf("+-----------------------Parâmetros da Construtiva-----------------------+%n");
                    gravarArq.printf("Iterações: %s %n", jtxtNumeroIteracoes.getText());
                    break;
                case 2:
                    gravarArq.printf("Meta heurística: Simulated Annealing %n");
                    gravarArq.printf("+-----------------------Parâmetros do SA----------------------------+%n");
                    gravarArq.printf("Iterações de vizinhança: %s %n", jtxtIteracoesVizinhanca.getText());
                    gravarArq.printf("Temperatura inicial: %s %n", jtxtTempInicial.getText());
                    gravarArq.printf("Temperatura de congelamento: %s %n", jtxtTempCongelamento.getText());
                    gravarArq.printf("Taxa de resfriamento: %s %n", jtxtTxResfriamento.getText());
                    gravarArq.printf("Peso na penalização: %s %n", jtxtPesoPenalizacaoSA.getText());
                    if (jCBConstrutivaInicial.isSelected())
                        gravarArq.printf("Solução inicial: Construtiva com %s iterações %n", jtxtQuantidadeIteracoesSA.getText());
                    else
                        gravarArq.printf("Solução inicial: Aleatória %n");
                    break;
                case 3:
                    gravarArq.printf("Meta heurística: GRASP %n");
                    gravarArq.printf("+-----------------------Parâmetros do GRASP-------------------------+%n");
                    gravarArq.printf("Iterações: %s %n", jtxtNumeroIteracoesGRASP.getText());
                    gravarArq.printf("Tamanho da LRC: %s %n", jtxtLRCGRASP.getText());
                    if (jRBPrimeiraMellhora.isSelected())
                        gravarArq.printf("Método de busca local: Primeira melhora %n");
                    else
                        gravarArq.printf("Método de busca local: Melhor melhora %n");
                    break;
                default:
                    break;
            }
            gravarArq.printf("+-------------------------------------------------------------------+%n");
            
            gravarArq.printf("Total da amostra: %d %n", listaIndividuo.size());
            gravarArq.printf("Volume total: %f %n", totalVolume);
            gravarArq.printf("Renda total: %f %n", totalRenda);
            gravarArq.printf("N° pátios: %d %n", numPatios);
            if (!jtxtFlexibilizacaoVolume.getText().trim().isEmpty()) {
                flexVolume = Double.parseDouble(jtxtFlexibilizacaoVolume.getText());
                gravarArq.printf("Restrição de volume: %f %n", restVolume);
                gravarArq.printf("Flexibilização de volume (mínimo): %f %n", restVolume - (restVolume * flexVolume / 100));
                gravarArq.printf("Flexibilização de volume (máximo): %f %n", restVolume + (restVolume * flexVolume / 100));
            }
            if (!jtxtFlexibilizacaoRenda.getText().trim().isEmpty()) {
                flexRenda = Double.parseDouble(jtxtFlexibilizacaoRenda.getText());
                gravarArq.printf("Restrição de renda: %f %n", restRenda);
                gravarArq.printf("Flexibilização de renda (mínimo): %f %n", restRenda - (restRenda * flexRenda / 100));
                gravarArq.printf("Flexibilização de renda (máximo): %f %n%n", restRenda + (restRenda * flexRenda / 100));
            }
            gravarArq.printf("+-----------------------------Resultado-----------------------------+%n");

            int i=0, total=0;
            
            double rendaTotal=0, volumeTotal=0, distanciaMediaTotal=0;
           //preenchendo as centrais
            for (Object valor: resultados.getSolucao()) {
                double rendaTotalPatio=0, volumeTotalPatio=0, distanciaMediaPatio=0;
                int contClasse1=0, contClasse2=0, contClasse3=0; 
                Individuo indIndividuo = listaIndividuo.get(Integer.parseInt(String.valueOf(valor))-1);
                //salvando dados do patio
                gravarArq.printf("|Patio: %d|%n", indIndividuo.getCodIndividuo());
                
                int j;
                //faz a marucataia de iniciar com 1 para não duplicar o individuo da central
                for (j=1; j < melhorResultado.get(i).size(); j++) {
                    Individuo individuo = listaIndividuo.get((int)melhorResultado.get(i).get(j)[0]-1);
                    
                    rendaTotalPatio += individuo.getRenda();
                    volumeTotalPatio += individuo.getVolume();
                    distanciaMediaPatio += distanciaEuclidianas[individuo.getCodIndividuo()-1][indIndividuo.getCodIndividuo()-1];
                    total++;

                    switch (individuo.getClasse()) {
                        case 1:
                            contClasse1++;
                            break;
                        case 2:
                            contClasse2++;
                            break;
                        default:
                            contClasse3++;
                            break;
                    }
                    //salvando dados do individuo
                    gravarArq.printf("%d\t", individuo.getCodIndividuo());                      
                }
                rendaTotal += rendaTotalPatio;
                volumeTotal += volumeTotalPatio;
                distanciaMediaTotal += distanciaMediaPatio;
                distanciaMediaPatio /= melhorResultado.get(i).size();
                i++;
                gravarArq.printf("%n");
                gravarArq.printf("Renda: %f%n", rendaTotalPatio);
                gravarArq.printf("Volume: %f%n", volumeTotalPatio);
                gravarArq.printf("Distância média: %f%n", distanciaMediaPatio);
                gravarArq.printf("Classe 1: %d \t Classe 2: %d \t Classe 3: %d %n%n", contClasse1, contClasse2, contClasse3);
            }
            gravarArq.printf("%n+---------------------------------------------------------------------+%n");
            gravarArq.printf("Renda total: %f%n", rendaTotal);
            gravarArq.printf("Volume total: %f%n", volumeTotal);
            gravarArq.printf("Distância total: %f%n", distanciaMediaTotal);
            distanciaMediaTotal /= distanciaEuclidianas.length;
            gravarArq.printf("Distância média total: %f%n", distanciaMediaTotal);
            gravarArq.printf("+---------------------------------------------------------------------+%n");
            gravarArq.printf("Combinações avaliadas: %d %n", resultados.getIteracoes());
            gravarArq.printf("Soluções viáveis: %d %n", resultados.getSolucoesViaveis());            
            gravarArq.printf("Soluções aceitas: %d %n", resultados.getSolucoesAceitas());
            gravarArq.printf("Tempo total de processamento: %d milisegundos %n", tempo);
            gravarArq.printf("+---------------------------------------------------------------------+%n");
            gravarArq.printf("Quantidade de individuos: %d %n", total);
            //gravarArq.printf("+--------------------------Relatório das FOs--------------------------+%n");
            //for (Object res: relatorio) {
            //    gravarArq.printf("%s %n", res.toString()); 
            //}
            arq.close();
        } catch (IOException ex) {
            Logger.getLogger(frmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="private XYDataset createDatasetInicial()">
    private XYDataset createDatasetInicial() {
        Individuos individuos = new Individuos();
        double normalizacaoDistancia = individuos.menorDistancia(listaIndividuo) - 200;
        
        final XYSeries series2 = new XYSeries(" ");
        final XYSeries series3 = new XYSeries("  ");
        final XYSeries floresta = new XYSeries("Floresta");

        for (Individuo individuo: listaIndividuo) {
            double X = individuo.getPosX();
            double Y = individuo.getPosY() - normalizacaoDistancia;
            floresta.add(X, Y);
        }

        final XYSeriesCollection dataset = new XYSeriesCollection();

        dataset.addSeries(series2);
        dataset.addSeries(series3);
        dataset.addSeries(floresta);

        return dataset;
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private XYDataset createDatasetProcessado() ">
    private XYDataset createDatasetProcessado(int numPatios) {
        
        Individuos individuos = new Individuos();
        
        double normalizacaoDistancia = individuos.menorDistancia(listaIndividuo) - 200;
        
        if (numPatios == 1) {

            final XYSeries centrais = new XYSeries("Centrais");
            final XYSeries cc = new XYSeries(" ");

            double x = melhorResultado.get(0).get(0)[1];
            double y = melhorResultado.get(0).get(0)[2] - normalizacaoDistancia;

            centrais.add(x, y);

            final XYSeries upa1 = new XYSeries("Floresta");
            
            for (Individuo individuo: listaIndividuo) {
                double x1 = individuo.getPosX();
                double y1 = individuo.getPosY() - normalizacaoDistancia;
                upa1.add(x1, y1);
            }

            final XYSeriesCollection dataset = new XYSeriesCollection();

            dataset.addSeries(centrais);
            dataset.addSeries(cc);
            dataset.addSeries(upa1);

            return dataset;

        }

        if (numPatios == 2) {

            final XYSeries centrais = new XYSeries("Centrais");

            double x = melhorResultado.get(0).get(0)[1];
            double y = melhorResultado.get(0).get(0)[2] - normalizacaoDistancia;
            double z = melhorResultado.get(1).get(0)[1];
            double w = melhorResultado.get(1).get(0)[2] - normalizacaoDistancia;

            centrais.add(x, y);
            centrais.add(z, w);

            final XYSeries upa1 = new XYSeries("Upa 1");
            for (int i = 0; i < melhorResultado.get(0).size(); i++) {

                double x1 = melhorResultado.get(0).get(i)[1];
                double y1 = melhorResultado.get(0).get(i)[2] - normalizacaoDistancia;

                upa1.add(x1, y1);

            }

            final XYSeries upa2 = new XYSeries("Upa 2");
            for (int i = 0; i < melhorResultado.get(1).size(); i++) {

                double x2 = melhorResultado.get(1).get(i)[1];
                double y2 = melhorResultado.get(1).get(i)[2] - normalizacaoDistancia;

                upa2.add(x2, y2);

            }

            final XYSeriesCollection dataset = new XYSeriesCollection();
            dataset.addSeries(centrais);

            dataset.addSeries(upa1);
            dataset.addSeries(upa2);

            return dataset;
        }
        if (numPatios == 3) {

            final XYSeries centrais = new XYSeries("Centrais");

            double x = melhorResultado.get(0).get(0)[1];
            double y = melhorResultado.get(0).get(0)[2] - normalizacaoDistancia;
            double z = melhorResultado.get(1).get(0)[1];
            double w = melhorResultado.get(1).get(0)[2] - normalizacaoDistancia;
            double a = melhorResultado.get(2).get(0)[1];
            double b = melhorResultado.get(2).get(0)[2] - normalizacaoDistancia;

            centrais.add(x, y);
            centrais.add(z, w);
            centrais.add(a, b);

            final XYSeries upa1 = new XYSeries("Upa 1");
            for (int i = 0; i < melhorResultado.get(0).size(); i++) {

                double x1 = melhorResultado.get(0).get(i)[1];
                double y1 = melhorResultado.get(0).get(i)[2] - normalizacaoDistancia;

                upa1.add(x1, y1);

            }

            final XYSeries upa2 = new XYSeries("Upa 2");
            for (int i = 0; i < melhorResultado.get(1).size(); i++) {

                double x2 = melhorResultado.get(1).get(i)[1];
                double y2 = melhorResultado.get(1).get(i)[2] - normalizacaoDistancia;

                upa2.add(x2, y2);

            }

            final XYSeries upa3 = new XYSeries("Upa 3");
            for (int i = 0; i < melhorResultado.get(2).size(); i++) {

                double x3 = melhorResultado.get(2).get(i)[1];
                double y3 = melhorResultado.get(2).get(i)[2] - normalizacaoDistancia;

                upa3.add(x3, y3);

            }

            final XYSeriesCollection dataset = new XYSeriesCollection();
            dataset.addSeries(centrais);

            dataset.addSeries(upa1);
            dataset.addSeries(upa2);
            dataset.addSeries(upa3);

            return dataset;

        }
        if (numPatios == 4) {

            final XYSeries centrais = new XYSeries("Centrais");

            double x = melhorResultado.get(0).get(0)[1];
            double y = melhorResultado.get(0).get(0)[2] - normalizacaoDistancia;
            double z = melhorResultado.get(1).get(0)[1];
            double w = melhorResultado.get(1).get(0)[2] - normalizacaoDistancia;
            double a = melhorResultado.get(2).get(0)[1];
            double b = melhorResultado.get(2).get(0)[2] - normalizacaoDistancia;
            double c = melhorResultado.get(3).get(0)[1];
            double d = melhorResultado.get(3).get(0)[2] - normalizacaoDistancia;

            centrais.add(x, y);
            centrais.add(z, w);
            centrais.add(a, b);
            centrais.add(c, d);

            final XYSeries floresta = new XYSeries("Upa 1");
            for (int i = 0; i < melhorResultado.get(0).size(); i++) {

                double x1 = melhorResultado.get(0).get(i)[1];
                double y1 = melhorResultado.get(0).get(i)[2] - normalizacaoDistancia;
                floresta.add(x1, y1);

            }

            final XYSeries floresta2 = new XYSeries("Upa 2");
            for (int i = 0; i < melhorResultado.get(1).size(); i++) {

                double x2 = melhorResultado.get(1).get(i)[1];
                double y2 = melhorResultado.get(1).get(i)[2] - normalizacaoDistancia;

                floresta2.add(x2, y2);

            }

            final XYSeries floresta3 = new XYSeries("Upa 3");
            for (int i = 0; i < melhorResultado.get(2).size(); i++) {

                double x3 = melhorResultado.get(2).get(i)[1];
                double y3 = melhorResultado.get(2).get(i)[2] - normalizacaoDistancia;

                floresta3.add(x3, y3);

            }

            final XYSeries floresta4 = new XYSeries("Upa 4");
            for (int i = 0; i < melhorResultado.get(3).size(); i++) {

                double x4 = melhorResultado.get(3).get(i)[1];
                double y4 = melhorResultado.get(3).get(i)[2] - normalizacaoDistancia;

                floresta4.add(x4, y4);

            }

            final XYSeriesCollection dataset = new XYSeriesCollection();

            dataset.addSeries(centrais);
            dataset.addSeries(floresta);
            dataset.addSeries(floresta2);
            dataset.addSeries(floresta3);
            dataset.addSeries(floresta4);

            return dataset;

        } else {

            final XYSeries centrais = new XYSeries("Centrais");

            double x = melhorResultado.get(0).get(0)[1];
            double y = melhorResultado.get(0).get(0)[2] - normalizacaoDistancia;
            double z = melhorResultado.get(1).get(0)[1];
            double w = melhorResultado.get(1).get(0)[2] - normalizacaoDistancia;
            double a = melhorResultado.get(2).get(0)[1];
            double b = melhorResultado.get(2).get(0)[2] - normalizacaoDistancia;
            double c = melhorResultado.get(3).get(0)[1];
            double d = melhorResultado.get(3).get(0)[2] - normalizacaoDistancia;
            double f = melhorResultado.get(3).get(0)[1];
            double g = melhorResultado.get(3).get(0)[2] - normalizacaoDistancia;

            centrais.add(x, y);
            centrais.add(z, w);
            centrais.add(a, b);
            centrais.add(c, d);
            centrais.add(f, g);
            
            final XYSeries floresta = new XYSeries("Upa 1");
            for (int i = 0; i < melhorResultado.get(0).size(); i++) {

                double x1 = melhorResultado.get(0).get(i)[1];
                double y1 = melhorResultado.get(0).get(i)[2] - normalizacaoDistancia;
                floresta.add(x1, y1);

            }

            final XYSeries floresta2 = new XYSeries("Upa 2");
            for (int i = 0; i < melhorResultado.get(1).size(); i++) {

                double x2 = melhorResultado.get(1).get(i)[1];
                double y2 = melhorResultado.get(1).get(i)[2] - normalizacaoDistancia;

                floresta2.add(x2, y2);

            }

            final XYSeries floresta3 = new XYSeries("Upa 3");
            for (int i = 0; i < melhorResultado.get(2).size(); i++) {

                double x3 = melhorResultado.get(2).get(i)[1];
                double y3 = melhorResultado.get(2).get(i)[2] - normalizacaoDistancia;

                floresta3.add(x3, y3);

            }

            final XYSeries floresta4 = new XYSeries("Upa 4");
            for (int i = 0; i < melhorResultado.get(3).size(); i++) {

                double x4 = melhorResultado.get(3).get(i)[1];
                double y4 = melhorResultado.get(3).get(i)[2] - normalizacaoDistancia;

                floresta4.add(x4, y4);

            }
            
            final XYSeries floresta5 = new XYSeries("Upa 5");
            for (int i = 0; i < melhorResultado.get(4).size(); i++) {

                double x5 = melhorResultado.get(4).get(i)[1];
                double y5 = melhorResultado.get(4).get(i)[2] - normalizacaoDistancia;

                floresta5.add(x5, y5);

            }

            final XYSeriesCollection dataset = new XYSeriesCollection();

            dataset.addSeries(centrais);
            dataset.addSeries(floresta);
            dataset.addSeries(floresta2);
            dataset.addSeries(floresta3);
            dataset.addSeries(floresta4);
            dataset.addSeries(floresta5);

            return dataset;

        }

    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public void CalculaDistancia(ArrayList<Individuo> listaIndividuo)">
    public void CalculaDistancia(ArrayList<Individuo> listaIndividuo) {
        double distancia;
        int n = listaIndividuo.size();
        int i = 0, j;
        for (Individuo individuo1: listaIndividuo) {
            for (j=i; j < n; j++) {
                Individuo individuo2 = listaIndividuo.get(j);
                distancia = Math.sqrt(Math.pow((individuo1.getPosX() - individuo2.getPosX()), 2) + Math.pow((individuo1.getPosY() - individuo2.getPosY()), 2));
                distanciaEuclidianas[i][j] = distancia;
                distanciaEuclidianas[j][i] = distancia;
            }
            i++;
        }
    }
    //</editor-fold>
 
    //<editor-fold defaultstate="collapsed" desc="public void plotarDadosInicial">
    public void plotarDadosInicial() {
        // cria o conjunto de dados
        XYDataset ds = createDatasetInicial();
       
        JFreeChart grafico = ChartFactory.createXYLineChart("Floresta em Análise", "UPAS", "", ds, PlotOrientation.VERTICAL, true, false, false);
       
        grafico.setBackgroundPaint(Color.WHITE);

        final XYPlot plot = grafico.getXYPlot();
        plot.setBackgroundPaint(Color.WHITE);
        plot.setDomainGridlinePaint(Color.WHITE);
        plot.setRangeGridlinePaint(Color.WHITE);

        final XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        for (int x = 0; x < 100; x++) {
            renderer.setSeriesLinesVisible(x, false);
        }

        plot.setRenderer(renderer);

        final NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        
        ChartPanel myChartPanel = new ChartPanel(grafico, true);
        myChartPanel.setSize(this.getjPanelGraf().getWidth(), this.getjPanelGraf().getHeight());
        myChartPanel.setVisible(true);
        
        this.getjPanelGraf().removeAll();
        this.getjPanelGraf().add(myChartPanel);
        this.getjPanelGraf().revalidate();
        this.getjPanelGraf().repaint();
    }
    // </editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public void plotarDadosProcessados">
    public void plotarDadosProcessados(int numPatios) {
        // cria o conjunto de dados
        XYDataset ds = createDatasetProcessado(numPatios);

        JFreeChart grafico = ChartFactory.createXYLineChart("Resultado", "UPAS", "", ds, PlotOrientation.VERTICAL, true, false, false);
        
        grafico.setBackgroundPaint(Color.WHITE);

        final XYPlot plot = grafico.getXYPlot();
        plot.setBackgroundPaint(Color.WHITE);
        plot.setDomainGridlinePaint(Color.WHITE);
        plot.setRangeGridlinePaint(Color.WHITE);

        final XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        for (int x = 0; x < 100; x++) {
            renderer.setSeriesLinesVisible(x, false);
            renderer.setSeriesPaint(1, java.awt.Color.BLUE);
            renderer.setSeriesPaint(2, java.awt.Color.GREEN);
            renderer.setSeriesPaint(3, java.awt.Color.ORANGE);
            renderer.setSeriesPaint(4, java.awt.Color.yellow);
            renderer.setSeriesPaint(5, java.awt.Color.MAGENTA);
        }

        plot.setRenderer(renderer);

        final NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        
        ChartPanel myChartPanel = new ChartPanel(grafico, true);
        myChartPanel.setSize(this.getjPanelGraf().getWidth(), this.getjPanelGraf().getHeight());
        myChartPanel.setVisible(true);
        
        this.getjPanelGraf().removeAll();
        this.getjPanelGraf().add(myChartPanel);
        this.getjPanelGraf().revalidate();
        this.getjPanelGraf().repaint();
    }
    // </editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public static void main(String args[])">
    public static void main(String args[]) {
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(frmMain.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(frmMain.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(frmMain.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(frmMain.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new frmMain().setVisible(true);
            }
        });
    }
    //</editor-fold>

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList<String> JLCentrais;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jBAdicionar;
    private javax.swing.JButton jBGerarGrafico;
    private javax.swing.JButton jBLimpar;
    private javax.swing.JButton jBProcessarConstrutiva;
    private javax.swing.JButton jBProcessarGRASP;
    private javax.swing.JButton jBProcessarSA;
    private javax.swing.JCheckBox jCBConstrutivaInicial;
    private javax.swing.JFrame jFrame1;
    private javax.swing.JLabel jLProgresso;
    private javax.swing.JLabel jLRestricaoRenda;
    private javax.swing.JLabel jLRestricaoVolume;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel28;
    private javax.swing.JLabel jLabel29;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPGRASP;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JPanel jPanelGraf;
    private javax.swing.JRadioButton jRBMelhorMelhora;
    private javax.swing.JRadioButton jRBPrimeiraMellhora;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextArea jTAResultados;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTabbedPane jTabbedPane2;
    private javax.swing.JButton jbAbrir;
    private javax.swing.JButton jbImportar;
    private javax.swing.JButton jbSelecionarArquivoResultado;
    private javax.swing.JLabel jlQuantidadeIteracoesSA;
    private javax.swing.JLabel jlTotalRegistros;
    private javax.swing.JLabel jlTotalRenda;
    private javax.swing.JLabel jlTotalVolume;
    private javax.swing.JPanel jpConstrutiva;
    private javax.swing.JPanel jpsimulatedAnnealing;
    private javax.swing.JTextField jtxtArquivo;
    private javax.swing.JTextField jtxtArquivoResultado;
    private javax.swing.JTextField jtxtCentral;
    private javax.swing.JTextField jtxtFlexibilizacaoRenda;
    private javax.swing.JTextField jtxtFlexibilizacaoVolume;
    private javax.swing.JTextField jtxtIteracoesVizinhanca;
    private javax.swing.JTextField jtxtLRCGRASP;
    private javax.swing.JTextField jtxtNumeroIteracoes;
    private javax.swing.JTextField jtxtNumeroIteracoesGRASP;
    private javax.swing.JTextField jtxtNumeroPatios;
    private javax.swing.JTextField jtxtNumeroTestesConstrutiva;
    private javax.swing.JTextField jtxtNumeroTestesGRASP;
    private javax.swing.JTextField jtxtNumeroTestesSA;
    private javax.swing.JTextField jtxtPesoPenalizacaoGRASP;
    private javax.swing.JTextField jtxtPesoPenalizacaoSA;
    private javax.swing.JTextField jtxtQuantidadeIteracoesSA;
    private javax.swing.JTextField jtxtTempCongelamento;
    private javax.swing.JTextField jtxtTempInicial;
    private javax.swing.JTextField jtxtTxResfriamento;
    // End of variables declaration//GEN-END:variables

}
