package classes;

import classes.Individuos.ResultadoDistancia;
import java.util.ArrayList;

/**
 * classe que implementa a interface BuscaLocal de modo a permitir que possam ser definidas as estratégias de busca
 * @author Marcelo
 */
public enum MetodoBuscaLocal implements BuscaLocal {
    
    PrimeiraMelhora {
        @Override
            public int[] buscaLocal(double[][] distanciasEuclidianas, int solucao[]) throws Exception {
                try {
                    Individuos ind = new Individuos();
                    int i, k;
                    int qtdeElementos = distanciasEuclidianas.length;
                    //calcula a FO da solução atual
                    ResultadoDistancia FO = ind.calculaDistanciaTotal(distanciasEuclidianas, solucao);
                    ResultadoDistancia FOAtual;
                    //para cada patio, faz a busca local verificando se melhorou
                    for (k=0; k<solucao.length; k++) {
                        int patio = solucao[k];
                        for (i=0; i<qtdeElementos; i++) {
                            solucao[k] = i+1;
                            FOAtual = ind.calculaDistanciaTotal(distanciasEuclidianas, solucao);
                            if (FOAtual.getDistancia() < FO.getDistancia()) {
                                FO.setDistancia(FOAtual.getDistancia());
                                patio = i+1;
                                break;//primeira melhora
                            }
                            else {
                                solucao[k] = patio;
                            }                        
                        }
                    }
                    return solucao;            
                }
                catch (Exception e) {
                    throw new Exception(e.toString());
                }
            }
        @Override    
             public int[] buscaLocal(double[][] distanciasEuclidianas,  ArrayList<Individuo> listaIndividuo, int solucao[], double penalizacao,
                     int indiVolumeRenda, double restricaoVolumeRenda, double flexRestricaoVolumeRenda) throws Exception {
                try {
                    Individuos ind = new Individuos();
                    int i, k;
                    int qtdeElementos = distanciasEuclidianas.length;
                    //calcula a FO da solução atual
                    ResultadoDistancia FO = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, solucao,
                            indiVolumeRenda, restricaoVolumeRenda, flexRestricaoVolumeRenda, penalizacao);
                    ResultadoDistancia FOAtual;
                    //para cada patio, faz a busca local verificando se melhorou
                    for (k=0; k<solucao.length; k++) {
                        int patio = solucao[k];
                        for (i=0; i<qtdeElementos; i++) {
                            solucao[k] = i+1;
                            FOAtual = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, solucao,
                                    indiVolumeRenda, restricaoVolumeRenda, flexRestricaoVolumeRenda, penalizacao);
                            if (FOAtual.getDistancia() < FO.getDistancia()) {
                                FO.setDistancia(FOAtual.getDistancia());
                                patio = i+1;
                                break;//primeira melhora
                            }
                            else {
                                solucao[k] = patio;
                            }                        
                        }
                    }
                    return solucao;            
                }
                catch (Exception e) {
                    throw new Exception(e.toString());
                }
            }           
        @Override
            public int[] buscaLocal(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int solucao[], double penalizacao,
                    double restricaoVolume, double flexRestricaoVolume, double restricaoRenda, double flexRestricaoRenda) throws Exception {
                try {
                    Individuos ind = new Individuos();
                    int i, k;
                    int qtdeElementos = distanciasEuclidianas.length;
                    //calcula a FO da solução atual
                    ResultadoDistancia FO = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, solucao, 
                            restricaoVolume, flexRestricaoVolume, restricaoRenda, flexRestricaoRenda, penalizacao);
                    ResultadoDistancia FOAtual;
                    //para cada patio, faz a busca local verificando se melhorou
                    for (k=0; k<solucao.length; k++) {
                        int patio = solucao[k];
                        for (i=0; i<qtdeElementos; i++) {
                            solucao[k] = i+1;
                            FOAtual = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, solucao,
                                    restricaoVolume, flexRestricaoVolume, restricaoRenda, flexRestricaoRenda, penalizacao);
                            if (FOAtual.getDistancia() < FO.getDistancia()) {
                                FO.setDistancia(FOAtual.getDistancia());
                                patio = i+1;
                                break;//primeira melhora
                            }
                            else {
                                solucao[k] = patio;
                            }                        
                        }
                    }
                    return solucao;            
                }
                catch (Exception e) {
                    throw new Exception(e.toString());
                }
            }
    },
    MelhorMelhora {
        @Override
            public int[] buscaLocal(double[][] distanciasEuclidianas, int solucao[]) throws Exception {
                try {
                    Individuos ind = new Individuos();
                    int i, k;
                    int qtdeElementos = distanciasEuclidianas.length;
                    //calcula a FO da solução atual
                    ResultadoDistancia FO = ind.calculaDistanciaTotal(distanciasEuclidianas, solucao);
                    ResultadoDistancia FOAtual;
                    //para cada patio, faz a busca local verificando se melhorou
                    for (k=0; k<solucao.length; k++) {
                        int patio = solucao[k];
                        for (i=0; i<qtdeElementos; i++) {
                            solucao[k] = i+1;
                            FOAtual = ind.calculaDistanciaTotal(distanciasEuclidianas, solucao);
                            if (FOAtual.getDistancia() < FO.getDistancia()) {
                                FO.setDistancia(FOAtual.getDistancia());
                                patio = i+1;
                            }
                            else {
                                solucao[k] = patio;
                            }                        
                        }
                    }
                    return solucao;            
                }
                catch (Exception e) {
                    throw new Exception(e.toString());
                }
            }
        @Override
            public int[] buscaLocal(double[][] distanciasEuclidianas,  ArrayList<Individuo> listaIndividuo, int solucao[], double penalizacao,
                     int indiVolumeRenda, double restricaoVolumeRenda, double flexRestricaoVolumeRenda) throws Exception {
                try {
                    Individuos ind = new Individuos();
                    int i, k;
                    int qtdeElementos = distanciasEuclidianas.length;
                    //calcula a FO da solução atual
                    ResultadoDistancia FO = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, solucao, 
                            indiVolumeRenda, restricaoVolumeRenda, flexRestricaoVolumeRenda, penalizacao);
                    ResultadoDistancia FOAtual;
                    //para cada patio, faz a busca local verificando se melhorou
                    for (k=0; k<solucao.length; k++) {
                        int patio = solucao[k];
                        for (i=0; i<qtdeElementos; i++) {
                            solucao[k] = i+1;
                            FOAtual = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, solucao,
                                    indiVolumeRenda, restricaoVolumeRenda, flexRestricaoVolumeRenda, penalizacao);
                            if (FOAtual.getDistancia() < FO.getDistancia()) {
                                FO.setDistancia(FOAtual.getDistancia());
                                patio = i+1;
                            }
                            else {
                                solucao[k] = patio;
                            }                        
                        }
                    }
                    return solucao;            
                }
                catch (Exception e) {
                    throw new Exception(e.toString());
                }
            }        
        @Override
            public int[] buscaLocal(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int solucao[], double penalizacao, 
            double restricaoVolume, double flexRestricaoVolume, double restricaoRenda, double flexRestricaoRenda) throws Exception {
                try {
                    Individuos ind = new Individuos();
                    int i, k;
                    int qtdeElementos = distanciasEuclidianas.length;
                    //calcula a FO da solução atual
                    ResultadoDistancia FO = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, solucao, 
                            restricaoVolume, flexRestricaoVolume, restricaoRenda, flexRestricaoRenda, penalizacao);
                    ResultadoDistancia FOAtual;
                    //para cada patio, faz a busca local verificando se melhorou
                    for (k=0; k<solucao.length; k++) {
                        int patio = solucao[k];
                        for (i=0; i<qtdeElementos; i++) {
                            solucao[k] = i+1;
                            FOAtual = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, solucao,
                                    restricaoVolume, flexRestricaoVolume, restricaoRenda, flexRestricaoRenda, penalizacao);
                            if (FOAtual.getDistancia() < FO.getDistancia()) {
                                FO.setDistancia(FOAtual.getDistancia());
                                patio = i+1;
                            }
                            else {
                                solucao[k] = patio;
                            }                        
                        }
                    }
                    return solucao;            
                }
                catch (Exception e) {
                    throw new Exception(e.toString());
                }
            }        
    };
}
