package classes;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Scanner;

/**
 * Classe responsável pela importação dos individuos
 * @author Marcelo Otone
 */
public class Individuos {
    
    public class ResultadoDistancia {
        private double distancia;
        private boolean viavel;

        public double getDistancia() {
            return distancia;
        }

        public void setDistancia(double distancia) {
            this.distancia = distancia;
        }

        public boolean isViavel() {
            return viavel;
        }

        public void setViavel(boolean viavel) {
            this.viavel = viavel;
        }
    }
    
    //<editor-fold defaultstate="collapsed" desc="public ArrayList<Individuo> Importar(String caminho)">
    public ArrayList<Individuo> Importar(String caminho) throws FileNotFoundException {
        ArrayList<Individuo> listaIndividuo = new ArrayList<Individuo>();
        listaIndividuo.clear();
        //importando os dados
        Scanner arquivo = new Scanner(new FileReader(caminho));
        arquivo.nextLine();   //Primeira linha do cabeçalho é pulada

        while (arquivo.hasNext()) {
            //instanciando objeto
            Individuo newIndividuo = new Individuo();
            //carregando dados no objeto
            newIndividuo.setCodIndividuo(Integer.parseInt(arquivo.next()));
            newIndividuo.setPosX(Double.parseDouble(arquivo.next()));
            newIndividuo.setPosY(Double.parseDouble(arquivo.next()));
            newIndividuo.setVolume(Double.parseDouble(arquivo.next()));
            newIndividuo.setAreaBasal(Double.parseDouble(arquivo.next()));
            newIndividuo.setRenda(Double.parseDouble(arquivo.next()));
            newIndividuo.setClasse(Integer.parseInt(arquivo.next()));
            
            //adicionando a lista
            listaIndividuo.add(newIndividuo);
        }
        arquivo.close();
        return listaIndividuo;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="public double menorDistancia(ArrayList<Individuo> ListaIndividuo)">
    public double menorDistancia(ArrayList<Individuo> ListaIndividuo) {
        if (ListaIndividuo.size() > 0) {
            double menorY = 0;
            for (Individuo fuste: ListaIndividuo) {
                if (fuste.getPosY() < menorY || menorY == 0)
                    menorY = fuste.getPosY();
            }
        return menorY;
        }
        return -1;
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public ResultadoDistancia calculaDistanciaTotal(double[][] distanciasEuclidianas, int patios[])">
    public ResultadoDistancia calculaDistanciaTotal(double[][] distanciasEuclidianas, int patios[]) throws Exception {
        try {
            ResultadoDistancia res = new ResultadoDistancia();
            //obtendo a quantidade de elementos da amostra
            int qtdeElementos = distanciasEuclidianas.length;
            int numeroPatios = patios.length;
            double distanciaTotal = 0; //variavel responsavel por armazenar a melhor distancia total
            int j, k;
            //comparando as distancias dos pontos aleatorios
            for (j=0; j<qtdeElementos; j++) {
                double distanciaMenor = 0;
                for (k=0; k<numeroPatios; k++) {
                    double distancia = distanciasEuclidianas[j][patios[k]-1];
                    if (distancia < distanciaMenor || k==0) {
                        distanciaMenor = distancia;
                    }
                }
                distanciaTotal += distanciaMenor;
            }

            res.distancia = distanciaTotal;
            res.viavel = true;
            return res;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public ResultadoDistancia calculaDistanciaTotal(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int patios[], int indiVolumeRenda, double restricaoVolumeRenda, double flexRestricaoVolumeRenda, double penalizacao)">
    public ResultadoDistancia calculaDistanciaTotal(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int patios[],
            int indiVolumeRenda, double restricaoVolumeRenda, double flexRestricaoVolumeRenda, double penalizacao) throws Exception {
        try {
            ResultadoDistancia res = new ResultadoDistancia();
            //obtendo a quantidade de elementos da amostra
            int qtdeElementos = distanciasEuclidianas.length;
            int numeroPatios = patios.length;
            double distanciaTotal = 0; //variavel responsavel por armazenar a melhor distancia total
            int i, j, k;
            //definindo restrição
            double restVolumeRendaAtual = restricaoVolumeRenda /= numeroPatios;
            double volumeRendaMinimo = restVolumeRendaAtual - (restVolumeRendaAtual * flexRestricaoVolumeRenda / 100);
            double volumeRendaMaximo = restVolumeRendaAtual + (restVolumeRendaAtual * flexRestricaoVolumeRenda / 100);

            double volumesRendasAtual[] = new double[numeroPatios]; //volumes ou rendas por pátio para validação de restrição
            //zerando volume ou renda dos pátios
            for (i=0; i<numeroPatios; i++) {
                volumesRendasAtual[i] = 0;
            }
            
            //comparando as distancias dos pontos aleatorios
            for (j=0; j<qtdeElementos; j++) {
                double distanciaMenor = 0;
                int patio = 0;
                for (k=0; k<numeroPatios; k++) {
                    double distancia = distanciasEuclidianas[j][patios[k]-1];
                    if (distancia < distanciaMenor || k==0) {
                        distanciaMenor = distancia;
                        patio = k;
                    }
                }
                distanciaTotal += distanciaMenor;

                Individuo individuo = listaIndividuo.get(j);
                //preencher volume ou renda por pátio
                if (indiVolumeRenda == 1)
                    volumesRendasAtual[patio] += individuo.getVolume();
                else if (indiVolumeRenda == 2)
                    volumesRendasAtual[patio] += individuo.getRenda();
            }

            //verifica se a solução é viável
            double diferenca = 0;
            for (int w=0; w<numeroPatios; w++) {
                diferenca += (volumesRendasAtual[w] <= volumeRendaMinimo) ? volumeRendaMinimo - volumesRendasAtual[w] : 
                            ((volumesRendasAtual[w] >= volumeRendaMaximo) ? volumesRendasAtual[w] - volumeRendaMaximo : 0);
            }

            //penalizando solução inviável
            distanciaTotal += penalizacao * diferenca;  //penalizacao é o theta e diferença é g()

            res.distancia = distanciaTotal;
            res.viavel = diferenca == 0;
            return res;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public ResultadoDistancia calculaDistanciaTotal(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int patios[], double restricaoVolume, double flexRestricaoVolume, double restricaoRenda, double flexRestricaoRenda, double penalizacao)">
    public ResultadoDistancia calculaDistanciaTotal(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int patios[],
            double restricaoVolume, double flexRestricaoVolume, double restricaoRenda, double flexRestricaoRenda, double penalizacao) throws Exception {
        try {
            ResultadoDistancia res = new ResultadoDistancia();
            //obtendo a quantidade de elementos da amostra
            int qtdeElementos = distanciasEuclidianas.length;
            int numeroPatios = patios.length;
            double distanciaTotal = 0; //variavel responsavel por armazenar a melhor distancia total
            int i, j, k;
            //definindo restrições
            double restVolumeAtual = restricaoVolume /= numeroPatios;
            double volumeMinimo = restVolumeAtual - (restVolumeAtual * flexRestricaoVolume / 100);
            double volumeMaximo = restVolumeAtual + (restVolumeAtual * flexRestricaoVolume / 100);
            double restRendaAtual = restricaoRenda /= numeroPatios;
            double rendaMinima = restRendaAtual - (restRendaAtual * flexRestricaoRenda / 100);
            double rendaMaxima = restRendaAtual + (restRendaAtual * flexRestricaoRenda / 100);

            double volumesAtual[] = new double[numeroPatios]; //volumes por pátio para validação de restrição
            double rendasAtual[] = new double[numeroPatios]; //rendas por pátio para validação da restrição
            //zerando volume ou renda dos pátios
            for (i=0; i<numeroPatios; i++) {
                volumesAtual[i] = 0;
                rendasAtual[i] = 0;
            }

            //comparando as distancias dos pontos aleatorios
            for (j=0; j<qtdeElementos; j++) {
                double distanciaMenor = 0;
                int patio = 0;
                for (k=0; k<numeroPatios; k++) {
                    double distancia = distanciasEuclidianas[j][patios[k]-1];
                    if (distancia < distanciaMenor || k==0) {
                        distanciaMenor = distancia;
                        patio = k;
                    }
                }
                distanciaTotal += distanciaMenor;

                Individuo individuo = listaIndividuo.get(j);
                //preencher volume ou renda por pátio
                volumesAtual[patio] += individuo.getVolume();
                rendasAtual[patio] += individuo.getRenda();
            }

            //verifica se a solução é viável
            double diferencaVolume = 0;
            double diferencaRenda = 0;
            for (int w=0; w<numeroPatios; w++) {
                diferencaVolume += (volumesAtual[w] <= volumeMinimo) ? volumeMinimo - volumesAtual[w] : 
                            ((volumesAtual[w] >= volumeMaximo) ? volumesAtual[w] - volumeMaximo : 0);
                diferencaRenda += (rendasAtual[w] <= rendaMinima) ? rendaMinima - rendasAtual[w] : 
                            ((rendasAtual[w] >= rendaMaxima) ? rendasAtual[w] - rendaMaxima : 0);
            }

            //penalizando solução inviável
            distanciaTotal += penalizacao * (diferencaVolume + diferencaRenda);  //penalizacao é o theta e diferença é g()

            res.distancia = distanciaTotal;
            res.viavel = (diferencaVolume == 0 && diferencaRenda == 0);
            return res;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
}
