package classes;

import java.util.ArrayList;
import java.util.Random;
import classes.Individuos.ResultadoDistancia;

/**
 * classe que irá compor as heuristicas e meta-heuristicas
 * @author Marcelo Otone
 */

public class Heuristica {
    
    private Boolean solucaoViavel;
    private Resultados resultado;
    private Individuos ind;
    
    public Heuristica() {
        solucaoViavel = false;
        resultado = new Resultados();
        ind = new Individuos();
    }

    public Boolean getSolucaoViavel() {
        return solucaoViavel;
    }

    public void setSolucaoViavel(Boolean solucaoViavel) {
        this.solucaoViavel = solucaoViavel;
    }
    
    //<editor-fold defaultstate="collapsed" desc="public Resultados heuristicaConstrutiva(double[][] distanciasEuclidianas, int numeroPatios, int iteracoes)">
    public Resultados heuristicaConstrutiva(double[][] distanciasEuclidianas, int numeroPatios, int iteracoes) throws Exception {
        try {
            ArrayList relatorio = new ArrayList();
            //instanciando a classe random
            Random gerador = new Random();
            //obtendo a quantidade de elementos da amostra
            int qtdeElementos = distanciasEuclidianas.length;

            int patios[] = new int[numeroPatios]; //vetor de patios
            int melhor[] = new int[numeroPatios]; //vetor q armazenará o melhor resultado
            double FOAnterior = Double.POSITIVE_INFINITY; //variavel responsavel por armazenar a melhor distancia total
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            ResultadoDistancia FO; //variavel que armazena a distancia total da iteração
            String res;
            int i, j;
            for (i=0; i<iteracoes; i++) {
                qtdeSolucoesViaveis++;

                //definido os numeros aleatorios da iteracao+1;
                for (j=0; j<numeroPatios; j++) {
                    patios[j] = gerador.nextInt(qtdeElementos)+1;
                }

                //comparando as distancias dos pontos aleatorios
                FO = ind.calculaDistanciaTotal(distanciasEuclidianas, patios);

                res = "FO: " + String.valueOf(FO.getDistancia()/qtdeElementos) + " - viável ";
                relatorio.add(res);

                //condição em que não há restrições de volume e renda
                if (FO.getDistancia() < FOAnterior) {
                    FOAnterior = FO.getDistancia();
                    qtdeSolucoesAceitas++;
                    for (j=0; j<numeroPatios; j++) {
                        melhor[j] = patios[j];
                    }
                }
            }
            resultado.setSolucao(melhor);
            resultado.setIteracoes(iteracoes);
            resultado.setSolucoesViaveis(qtdeSolucoesViaveis);
            resultado.setSolucoesAceitas(qtdeSolucoesAceitas);
            resultado.setRelatorio(relatorio);
            return resultado;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public Resultados heuristicaConstrutiva(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int iteracoes, int VolumeRenda, double restricaoVolumeRenda, double flexRestricaoVolumeRenda">
    public Resultados heuristicaConstrutiva(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, 
                                            int iteracoes, int indiVolumeRenda, double restricaoVolumeRenda, double flexRestricaoVolumeRenda) throws Exception {
        try {
            ArrayList relatorio = new ArrayList();
            //instanciando a classe random
            Random gerador = new Random();
            //obtendo a quantidade de elementos da amostra
            int qtdeElementos = distanciasEuclidianas.length;
            int patios[] = new int[numeroPatios]; //vetor de patios
            int melhor[] = new int[numeroPatios]; //vetor q armazenará o melhor resultado
            double FOAnterior = Double.POSITIVE_INFINITY; //variavel responsavel por armazenar a melhor distancia total
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            ResultadoDistancia FO; //variavel que armazena a distancia total da iteração
            String res;
            int i, j;

            for (i=0; i<iteracoes; i++) {
                //definido os numeros aleatorios da iteracao+1;
                for (j=0; j<numeroPatios; j++) {
                    patios[j] = gerador.nextInt(qtdeElementos)+1;
                }
                
                //comparando as distancias dos pontos aleatorios
                FO = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, patios, indiVolumeRenda, restricaoVolumeRenda, flexRestricaoVolumeRenda, 1);

                //verifica se a solução é viável
                if (FO.isViavel()) {
                    qtdeSolucoesViaveis++;
                    res = "FO: " + String.valueOf(FO.getDistancia()/qtdeElementos) + " - viável ";
                }
                else
                    res = "FO: " + String.valueOf(FO.getDistancia()/qtdeElementos) + " - inviável ";
                relatorio.add(res);

                //condição em que há restrições de volume
                if (FO.getDistancia() < FOAnterior && FO.isViavel()) {
                    qtdeSolucoesAceitas++;
                    FOAnterior = FO.getDistancia();

                    for (j=0; j<numeroPatios; j++) {
                        melhor[j] = patios[j];
                    }
                }
            }
            resultado.setSolucao(melhor);
            resultado.setIteracoes(iteracoes);
            resultado.setSolucoesViaveis(qtdeSolucoesViaveis);
            resultado.setSolucoesAceitas(qtdeSolucoesAceitas);
            resultado.setRelatorio(relatorio);
            return resultado;            
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public Resultados heuristicaConstrutiva(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int iteracoes, double restricaoVolume, double flexRestricaoVolume, double restricaoRenda, double flexRestricaoRenda">
    public Resultados heuristicaConstrutiva(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, 
                                            int numeroPatios, int iteracoes, double restricaoVolume, double flexRestricaoVolume, 
                                            double restricaoRenda, double flexRestricaoRenda) throws Exception {
        try {
            ArrayList relatorio = new ArrayList();
            //instanciando a classe random
            Random gerador = new Random();
            //obtendo a quantidade de elementos da amostra
            int qtdeElementos = distanciasEuclidianas.length;
            int patios[] = new int[numeroPatios]; //vetor de patios
            int melhor[] = new int[numeroPatios]; //vetor q armazenará o melhor resultado
            double FOAnterior = Double.POSITIVE_INFINITY; //variavel responsavel por armazenar a melhor distancia total
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            ResultadoDistancia FO; //variavel que armazena a distancia total da iteração
            String res;
            int i, j;

            for (i=0; i<iteracoes; i++) {
                //definido os numeros aleatorios da iteracao
                for (j=0; j<numeroPatios; j++) {
                    patios[j] = gerador.nextInt(qtdeElementos)+1;
                }

                //comparando as distancias dos pontos aleatorios
                FO = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, patios, restricaoVolume, flexRestricaoVolume, restricaoRenda, flexRestricaoRenda, 1);

                //verifica se a solução é viável
                if (FO.isViavel()) {
                    qtdeSolucoesViaveis++;
                    res = "FO: " + String.valueOf(FO.getDistancia()/qtdeElementos) + " - viável ";
                }
                else
                    res = "FO: " + String.valueOf(FO.getDistancia()/qtdeElementos) + " - inviável ";
                relatorio.add(res);

                //condição em que há restrições de volume e renda
                if (FO.getDistancia() < FOAnterior && FO.isViavel()) {
                    qtdeSolucoesAceitas++;
                    FOAnterior = FO.getDistancia();

                    for (j=0; j<numeroPatios; j++) {
                        melhor[j] = patios[j];
                    }
                }
            }
            resultado.setSolucao(melhor);
            resultado.setIteracoes(iteracoes);
            resultado.setSolucoesViaveis(qtdeSolucoesViaveis);
            resultado.setSolucoesAceitas(qtdeSolucoesAceitas);
            resultado.setRelatorio(relatorio);
            return resultado;            
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public Resultados simulatedAnnealing(double[][] distanciasEuclidianas, int numeroPatios, double txResfriamento, int iteracoes, double tempInicial, double tempCongelamento, int solucaoInicial[])">
    public Resultados simulatedAnnealing(double[][] distanciasEuclidianas, int numeroPatios, double txResfriamento, 
            int iteracoesVizinhanca, double tempInicial, double tempCongelamento, int solucaoInicial[]) throws Exception {
        try {
            int resQtdeViaveis = 0;
            int resQtdeIteracoes = 0;
            int resQtdeAceitas = 0;
            resultado.setIteracoes(resQtdeIteracoes);
            resultado.setSolucoesViaveis(resQtdeViaveis);
            resultado.setSolucoesAceitas(resQtdeAceitas);            
            
            //instanciando a classe random
            Random gerador = new Random();
            //inicializando variáveis
            ArrayList relatorio = new ArrayList();
            final double euler = 2.718281828459045235360287;
            int qtdeElementos = distanciasEuclidianas.length;
            int solAtual[] = new int[qtdeElementos]; //vetor de patios - solução atual
            int melhorSolucao[] = new int[numeroPatios];  //declarando o array para melhor solução obtida até então
            //inicializando o vetor solAtual
            for (int i=0; i<qtdeElementos; i++)
                solAtual[i] = 0;
            //marcando com 1 os elementos da solução inicial

            int vizinho[], i, j, k, patio;
            for (k=0; k<numeroPatios; k++) {
                patio = solucaoInicial[k];
                solAtual[patio-1] = 1;
                melhorSolucao[k] = patio;
            }

            //inicializando variáveis
            ResultadoDistancia distVizinho;
            ResultadoDistancia distInicial;
            ResultadoDistancia distMelhor;
            int IterTemp = 0;                       //numero de iterações na temperatura T
            double temp = tempInicial;              //temperatura corrente
            String res;
            double x, variacao;
            
            while (temp > tempCongelamento) {
                while (IterTemp < iteracoesVizinhanca) {
                    resQtdeIteracoes++;
                    resQtdeViaveis++;
                    IterTemp++;
                    vizinho = gerarVizinho(solAtual, solucaoInicial, numeroPatios);
                    //obtendo a variação da solução inicial para o vizinho
                    distVizinho = ind.calculaDistanciaTotal(distanciasEuclidianas, vizinho);
                    distInicial = ind.calculaDistanciaTotal(distanciasEuclidianas, solucaoInicial);
                    distMelhor = ind.calculaDistanciaTotal(distanciasEuclidianas, melhorSolucao);
                    variacao = distVizinho.getDistancia() - distInicial.getDistancia();
                    
                    //gerando relatorio para determinacao do peso
                    res = "FO: " + String.valueOf(distVizinho.getDistancia()/qtdeElementos) + " - viável ";
                    relatorio.add(res);
                    
                    //atualizando matriz da solução atual
                    for (i=0; i<qtdeElementos; i++)
                        solAtual[i] = 0;
                    //se a variação é menor q zero, então melhorou
                    if (variacao < 0) {
                        //melhorou a solução inicial em relação ao vizinho
                        resQtdeAceitas++;
                        for (i=0; i<numeroPatios; i++) {
                            patio = vizinho[i];
                            solAtual[patio-1] = 1;
                            solucaoInicial[i] = patio;
                        }

                        if (distVizinho.getDistancia() < distMelhor.getDistancia()) {
                            //melhorou a melhor até o momento em relação ao vizinho
                            for (j=0; j<numeroPatios; j++)
                                melhorSolucao[j] = vizinho[j];
                        }
                    }
                    else {
                        x = gerador.nextFloat() % 1001;
                        x /= 1000;
                        if (x < Math.pow(euler, (-variacao/temp))) {
                            //atualizando matriz da solução atual
                            //pega o vizinho mesmo este não sendo melhor
                            resQtdeAceitas++;
                            for (i=0; i<numeroPatios; i++) {
                                patio = vizinho[i];
                                solAtual[patio-1] = 1;
                                solucaoInicial[i] = patio;
                            }
                        }
                        else {
                            //corrige solução atual
                            for (j=0; j<numeroPatios; j++) {
                                patio = solucaoInicial[j];
                                solAtual[patio-1] = 1;
                            }
                        }
                    }
                }
                temp = txResfriamento * temp;
                IterTemp = 0;
            }
            resultado.setSolucao(melhorSolucao);
            resultado.setIteracoes(resultado.getIteracoes()+resQtdeIteracoes);
            resultado.setSolucoesViaveis(resultado.getSolucoesViaveis()+resQtdeViaveis);
            resultado.setSolucoesAceitas(resultado.getSolucoesAceitas()+resQtdeAceitas);
            resultado.setRelatorio(relatorio);
            return resultado;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public Resultados simulatedAnnealing(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, double txResfriamento, int iteracoesVizinhanca, double tempInicial, double tempCongelamento, double penalizacao, int solucaoInicial[], int indiVolumeRenda, double restricaoVolumeRenda, double flexRestricaoVolumeRenda)">
    public Resultados simulatedAnnealing(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, 
            double txResfriamento, int iteracoesVizinhanca, double tempInicial, double tempCongelamento, double penalizacao, int solucaoInicial[], 
            int indiVolumeRenda, double restricaoVolumeRenda, double flexRestricaoVolumeRenda) throws Exception {
        
        try {
            int resQtdeViaveis = 0;
            int resQtdeIteracoes = 0;
            int resQtdeAceitas = 0;
            resultado.setIteracoes(resQtdeIteracoes);
            resultado.setSolucoesViaveis(resQtdeViaveis);
            resultado.setSolucoesAceitas(resQtdeAceitas); 
            int melhorSolucao[] = new int[numeroPatios];  //declarando o array para melhor solução obtida até então

            //instanciando a classe random
            Random gerador = new Random();
            //inicializando variáveis
            ArrayList relatorio = new ArrayList(); 
            final double euler = 2.718281828459045235360287;
            int qtdeElementos = distanciasEuclidianas.length;
            int solAtual[] = new int[qtdeElementos]; //vetor de patios - solução atual
            //inicializando o vetor solAtual
            for (int i=0; i<qtdeElementos; i++)
                solAtual[i] = 0;

            int vizinho[], i, j, k, patio;
            //marcando com 1 os elementos da solução inicial
            for (k=0; k<numeroPatios; k++) {
                patio = solucaoInicial[k];
                solAtual[patio-1] = 1;
                melhorSolucao[k] = patio;
            }

            //inicializando variáveis
            ResultadoDistancia distVizinho;
            ResultadoDistancia distInicial;
            ResultadoDistancia distMelhor;
            int IterTemp = 0;                       //numero de iterações na temperatura T
            double temp = tempInicial;              //temperatura corrente
            String res;
            double x, variacao;
            
            while (temp > tempCongelamento) {
                while (IterTemp < iteracoesVizinhanca) {
                    resQtdeIteracoes++;
                    IterTemp++;
                    vizinho = gerarVizinho(solAtual, solucaoInicial, numeroPatios);

                    //obtendo a variação da solução inicial para o vizinho
                    distVizinho = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, vizinho, indiVolumeRenda, 
                                                               restricaoVolumeRenda, flexRestricaoVolumeRenda, penalizacao);
                    distInicial = ind.calculaDistanciaTotal(distanciasEuclidianas, solucaoInicial);
                    distMelhor = ind.calculaDistanciaTotal(distanciasEuclidianas, melhorSolucao);
                    variacao = distVizinho.getDistancia() - distInicial.getDistancia();
                    
                    //gerando relatorio para determinacao do peso
                    res = "FO: " + String.valueOf(distVizinho.getDistancia()/qtdeElementos) + (distVizinho.isViavel() ? " - viável " : " - inviável ");
                    if (getSolucaoViavel())
                        resQtdeViaveis++;
                    relatorio.add(res);

                    //atualizando matriz da solução atual
                    for (i=0; i<qtdeElementos; i++)
                        solAtual[i] = 0;
                    //se a variação é menor q zero, então melhorou
                    if (variacao < 0) {
                        //melhorou a solução inicial em relação ao vizinho
                        resQtdeAceitas++;
                        for (i=0; i<numeroPatios; i++) {
                            patio = vizinho[i];
                            solAtual[patio-1] = 1;
                            solucaoInicial[i] = patio;
                        }

                        if (distVizinho.getDistancia() < distMelhor.getDistancia()) {
                            //melhorou a melhor até o momento em relação ao vizinho
                            for (j=0; j<numeroPatios; j++)
                                melhorSolucao[j] = vizinho[j];
                        }
                    }
                    else {
                        x = gerador.nextFloat() % 1001;
                        x /= 1000;
                        if (x < Math.pow(euler, (-variacao/temp))) {
                            //atualizando matriz da solução atual
                            //pega o vizinho mesmo este não sendo melhor
                            resQtdeAceitas++;
                            for (i=0; i<numeroPatios; i++) {
                                patio = vizinho[i];
                                solAtual[patio-1] = 1;
                                solucaoInicial[i] = patio;
                            }
                        }
                        else {
                            //corrige solução atual
                            for (j=0; j<numeroPatios; j++) {
                                patio = solucaoInicial[j];
                                solAtual[patio-1] = 1;
                            }
                        }
                    }
                }
                temp = txResfriamento * temp;
                IterTemp = 0;
            }
            resultado.setSolucao(melhorSolucao);
            resultado.setIteracoes(resultado.getIteracoes()+resQtdeIteracoes);
            resultado.setSolucoesViaveis(resultado.getSolucoesViaveis()+resQtdeViaveis);
            resultado.setSolucoesAceitas(resultado.getSolucoesAceitas()+resQtdeAceitas);
            resultado.setRelatorio(relatorio);
            return resultado;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public Resultados simulatedAnnealing(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, double txResfriamento, int iteracoesVizinhanca, double tempInicial, double tempCongelamento, double penalizacao, int solucaoInicial[], double restricaoVolume, double flexRestricaoVolume, double restricaoRenda, double flexRestricaoRenda)">
    public Resultados simulatedAnnealing(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, 
            double txResfriamento, int iteracoesVizinhanca, double tempInicial, double tempCongelamento, double penalizacao, int solucaoInicial[], 
            double restricaoVolume, double flexRestricaoVolume, double restricaoRenda, double flexRestricaoRenda) throws Exception {
        try {
            int resQtdeViaveis = 0;
            int resQtdeIteracoes = 0;
            int resQtdeAceitas = 0;
            resultado.setIteracoes(resQtdeIteracoes);
            resultado.setSolucoesViaveis(resQtdeViaveis);
            resultado.setSolucoesAceitas(resQtdeAceitas); 
            int melhorSolucao[] = new int[numeroPatios];  //declarando o array para melhor solução obtida até então

            //instanciando a classe random
            Random gerador = new Random();
            //inicializando variáveis
            ArrayList relatorio = new ArrayList();
            final double euler = 2.718281828459045235360287;
            int qtdeElementos = distanciasEuclidianas.length;
            int solAtual[] = new int[qtdeElementos]; //vetor de patios - solução atual
            //inicializando o vetor solAtual
            for (int i=0; i<qtdeElementos; i++)
                solAtual[i] = 0;

            int vizinho[], i, j, k, patio;
            //marcando com 1 os elementos da solução inicial
            for (k=0; k<numeroPatios; k++) {
                patio = solucaoInicial[k];
                solAtual[patio-1] = 1;
                melhorSolucao[k] = patio;
            }

            //inicializando variáveis
            ResultadoDistancia distVizinho;
            ResultadoDistancia distInicial;
            ResultadoDistancia distMelhor;
            int IterTemp = 0;                       //numero de iterações na temperatura T
            double temp = tempInicial;              //temperatura corrente
            String res;
            double x, variacao;
            
            while (temp > tempCongelamento) {
                while (IterTemp < iteracoesVizinhanca) {
                    resQtdeIteracoes++;
                    IterTemp++;
                    vizinho = gerarVizinho(solAtual, solucaoInicial, numeroPatios);

                    //obtendo a variação da solução inicial para o vizinho
                    distVizinho = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, vizinho, restricaoVolume, 
                            flexRestricaoVolume, restricaoRenda, flexRestricaoRenda, penalizacao);
                    distInicial = ind.calculaDistanciaTotal(distanciasEuclidianas, solucaoInicial);
                    distMelhor = ind.calculaDistanciaTotal(distanciasEuclidianas, melhorSolucao);
                    variacao = distVizinho.getDistancia() - distInicial.getDistancia();
                    
                    //gerando relatorio para determinacao do peso
                    res = "FO: " + String.valueOf(distVizinho.getDistancia()/qtdeElementos) + (distVizinho.isViavel() ? " - viável " : " - inviável ");
                    if (getSolucaoViavel())
                        resQtdeViaveis++;
                    relatorio.add(res);

                    //atualizando matriz da solução atual
                    for (i=0; i<qtdeElementos; i++)
                        solAtual[i] = 0;
                    //se a variação é menor q zero, então melhorou
                    if (variacao < 0) {
                        //melhorou a solução inicial em relação ao vizinho
                        resQtdeAceitas++;
                        for (i=0; i<numeroPatios; i++) {
                            patio = vizinho[i];
                            solAtual[patio-1] = 1;
                            solucaoInicial[i] = patio;
                        }

                        if (distVizinho.getDistancia() < distMelhor.getDistancia()) {
                            //melhorou a melhor até o momento em relação ao vizinho
                            for (j=0; j<numeroPatios; j++)
                                melhorSolucao[j] = vizinho[j];
                        }
                    }
                    else {
                        x = gerador.nextFloat() % 1001;
                        x /= 1000;
                        if (x < Math.pow(euler, (-variacao/temp))) {
                            //atualizando matriz da solução atual
                            //pega o vizinho mesmo este não sendo melhor
                            resQtdeAceitas++;
                            for (i=0; i<numeroPatios; i++) {
                                patio = vizinho[i];
                                solAtual[patio-1] = 1;
                                solucaoInicial[i] = patio;
                            }
                        }
                        else {
                            //corrige solução atual
                            for (j=0; j<numeroPatios; j++) {
                                patio = solucaoInicial[j];
                                solAtual[patio-1] = 1;
                            }
                        }
                    }
                }
                temp = txResfriamento * temp;
                IterTemp = 0;
            }
            resultado.setSolucao(melhorSolucao);
            resultado.setIteracoes(resultado.getIteracoes()+resQtdeIteracoes);
            resultado.setSolucoesViaveis(resultado.getSolucoesViaveis()+resQtdeViaveis);
            resultado.setSolucoesAceitas(resultado.getSolucoesAceitas()+resQtdeAceitas);
            resultado.setRelatorio(relatorio);
            return resultado;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="public Resultados GRASP(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int iteracoes, int LRC, MetodoBuscaLocal metodoBusca)">
    public Resultados GRASP(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int iteracoes, int LRC, MetodoBuscaLocal metodoBusca) throws Exception {
        try {
            ArrayList relatorio = new ArrayList();

            String rel;
            //inicializando as variáveis
            int iter = 0;
            int k;
            double FO = Double.POSITIVE_INFINITY;  //valor inicial da FO, o objetivo é aceitar na primeira
            ResultadoDistancia FOAtual;
            int atual[]; //vetor q armazenará a solução atual
            int melhor[] = new int[numeroPatios]; //vetor q armazenará o melhor resultado
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            resultado.setIteracoes(0);
            resultado.setSolucoesViaveis(qtdeSolucoesViaveis);
            resultado.setSolucoesAceitas(qtdeSolucoesAceitas);
        
            while (iter < iteracoes) {
                qtdeSolucoesViaveis++;
                iter++;
                atual = construtivaGRASP(distanciasEuclidianas, listaIndividuo, numeroPatios, LRC);
                //fazer busca local - método da melhor melhora
                atual =  metodoBusca.buscaLocal(distanciasEuclidianas, atual);
                FOAtual =  ind.calculaDistanciaTotal(distanciasEuclidianas, atual);
                
                rel = "FO: " + String.valueOf(FOAtual) + " - viável ";
                relatorio.add(rel);
            
                if (FOAtual.getDistancia() < FO) {
                    qtdeSolucoesAceitas++;
                    FO = FOAtual.getDistancia();
                    for (k=0; k<numeroPatios; k++) {
                        melhor[k] = atual[k];
                    }
                }
            }
            resultado.setSolucao(melhor);
            resultado.setIteracoes(resultado.getIteracoes()+iteracoes);
            resultado.setSolucoesViaveis(resultado.getSolucoesViaveis()+qtdeSolucoesViaveis);
            resultado.setSolucoesAceitas(resultado.getSolucoesAceitas()+qtdeSolucoesAceitas);
            resultado.setRelatorio(relatorio);
            return resultado;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public Resultados GRASP(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int iteracoes, int LRC, MetodoBuscaLocal metodoBusca, double penalizacao, int indiVolumeRenda, double restricaoVolumeRenda, double flexRestricaoVolumeRenda)">
    public Resultados GRASP(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int iteracoes, int LRC, MetodoBuscaLocal metodoBusca,
            double penalizacao, int indiVolumeRenda, double restricaoVolumeRenda, double flexRestricaoVolumeRenda) throws Exception {
        try {
            ArrayList relatorio = new ArrayList();

            String rel;
            //inicializando as variáveis
            int iter = 0;
            int k;
            double FO = Double.POSITIVE_INFINITY;  //valor inicial da FO, o objetivo é aceitar na primeira
            ResultadoDistancia FOAtual;
            int atual[]; //vetor q armazenará a solução atual
            int melhor[] = new int[numeroPatios]; //vetor q armazenará o melhor resultado
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            resultado.setIteracoes(0);
            resultado.setSolucoesViaveis(qtdeSolucoesViaveis);
            resultado.setSolucoesAceitas(qtdeSolucoesAceitas);
        
            while (iter < iteracoes) {
                qtdeSolucoesViaveis++;
                iter++;
                atual = construtivaGRASP(distanciasEuclidianas, listaIndividuo, numeroPatios, LRC, penalizacao, indiVolumeRenda, restricaoVolumeRenda, flexRestricaoVolumeRenda);
                //fazer busca local - método da melhor melhora
                atual =  metodoBusca.buscaLocal(distanciasEuclidianas, listaIndividuo, atual, penalizacao, indiVolumeRenda, restricaoVolumeRenda, flexRestricaoVolumeRenda);
                FOAtual =  ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, atual, indiVolumeRenda, restricaoVolumeRenda, flexRestricaoVolumeRenda, penalizacao);
                
                rel = "FO: " + String.valueOf(FOAtual) + " - viável ";
                relatorio.add(rel);
            
                if (FOAtual.getDistancia() < FO) {
                    qtdeSolucoesAceitas++;
                    FO = FOAtual.getDistancia();
                    for (k=0; k<numeroPatios; k++) {
                        melhor[k] = atual[k];
                    }
                }
            }
            resultado.setSolucao(melhor);
            resultado.setIteracoes(resultado.getIteracoes()+iteracoes);
            resultado.setSolucoesViaveis(resultado.getSolucoesViaveis()+qtdeSolucoesViaveis);
            resultado.setSolucoesAceitas(resultado.getSolucoesAceitas()+qtdeSolucoesAceitas);
            resultado.setRelatorio(relatorio);
            return resultado;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="public Resultados GRASP(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int iteracoes, int LRC, MetodoBuscaLocal metodoBusca, double penalizacao, double restricaoVolume, double flexRestricaoVolume, double restricaoRenda, double flexRestricaoRenda)">
    public Resultados GRASP(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int iteracoes,
            int LRC, MetodoBuscaLocal metodoBusca, double penalizacao, double restricaoVolume, double flexRestricaoVolume, 
            double restricaoRenda, double flexRestricaoRenda) throws Exception {
        try {
            ArrayList relatorio = new ArrayList();

            String rel;
            //inicializando as variáveis
            int iter = 0;
            int k;
            double FO = Double.POSITIVE_INFINITY;  //valor inicial da FO, o objetivo é aceitar na primeira
            ResultadoDistancia FOAtual;
            int atual[]; //vetor q armazenará a solução atual
            int melhor[] = new int[numeroPatios]; //vetor q armazenará o melhor resultado
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            resultado.setIteracoes(0);
            resultado.setSolucoesViaveis(qtdeSolucoesViaveis);
            resultado.setSolucoesAceitas(qtdeSolucoesAceitas);
        
            while (iter < iteracoes) {
                qtdeSolucoesViaveis++;
                iter++;
                atual = construtivaGRASP(distanciasEuclidianas, listaIndividuo, numeroPatios, LRC,
                        penalizacao, restricaoVolume, flexRestricaoVolume, restricaoRenda, flexRestricaoRenda);
                //fazer busca local - método da melhor melhora
                atual =  metodoBusca.buscaLocal(distanciasEuclidianas, listaIndividuo, atual, penalizacao, restricaoVolume,
                        flexRestricaoVolume, restricaoRenda, flexRestricaoRenda);
                FOAtual =  ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, atual, restricaoVolume,
                        flexRestricaoVolume, restricaoRenda, flexRestricaoRenda, penalizacao);
                
                rel = "FO: " + String.valueOf(FOAtual) + " - viável ";
                relatorio.add(rel);
            
                if (FOAtual.getDistancia() < FO) {
                    qtdeSolucoesAceitas++;
                    FO = FOAtual.getDistancia();
                    for (k=0; k<numeroPatios; k++) {
                        melhor[k] = atual[k];
                    }
                }
            }
            resultado.setSolucao(melhor);
            resultado.setIteracoes(resultado.getIteracoes()+iteracoes);
            resultado.setSolucoesViaveis(resultado.getSolucoesViaveis()+qtdeSolucoesViaveis);
            resultado.setSolucoesAceitas(resultado.getSolucoesAceitas()+qtdeSolucoesAceitas);
            resultado.setRelatorio(relatorio);
            return resultado;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private int[] gerarVizinho(int atual[], int melhorLocal[], int numeroPatios)">
    private int[] gerarVizinho(int atual[], int melhorLocal[], int numeroPatios) throws Exception {
        try {
            int[] solAtual = new int[numeroPatios];
            //instanciando a classe random
            Random gerador = new Random();
            int i;
            for (i=0; i<numeroPatios; i++) {
                solAtual[i] = melhorLocal[i];
            }
            //obtendo a posicao aleatoria de troca
            int troca = gerador.nextInt(numeroPatios);

            int vizinho;
            do {
                vizinho = gerador.nextInt(atual.length)+1;
                solAtual[troca] = vizinho;
            } while (atual[vizinho-1] == 1);

            return solAtual;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private int[] construtivaGRASP(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int LRC)">
    private int[] construtivaGRASP(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int LRC) throws Exception {
        try {
            //instanciando a classe random
            Random gerador = new Random();
            
            int qtdeElementos = listaIndividuo.size();
            int ListaRC[] = new int[LRC];
            int candidato, i, j, k;
            double anteriorFO = Double.POSITIVE_INFINITY; //vetor para armazenar os valores das FOs dos pátios
            ResultadoDistancia candidatoFO;
            int solAtual[] = new int[numeroPatios];
            int melhor[] = new int[numeroPatios];            

            //criando lista de validação de candidatos
            int candidatos[] = new int[qtdeElementos]; //lista de candidatos que ainda não foram selecionados
            //inicializando o vetor solAtual
            for (i=0; i<qtdeElementos; i++)
                candidatos[i] = 0;

            //gerando a lista restritiva de candidatos
            for (i=0; i<LRC; i++) {
                //garantindo que nenhum candidato escolhido seja repetido
                do {
                    //obtendo uma árvore aleatoriamente para considerar como candidato
                    candidato = gerador.nextInt(qtdeElementos)+1;
                } while (candidatos[candidato-1] == 1);
                
                candidatos[candidato-1] = 1;
                ListaRC[i] = candidato;
            }
            
            //avaliando as combinações entre os candidatos
            for (i=0; i<(ListaRC.length-numeroPatios); i++) {
                resultado.setIteracoes(resultado.getIteracoes()+1);
                resultado.setSolucoesViaveis(resultado.getSolucoesViaveis()+1);
                for (j=i; j<(i+numeroPatios); j++) {
                    //preenchendo a solução atual para calcular a FO
                    solAtual[j-i] = ListaRC[j];
                }
                //calculando FO da solução atual e validando
                candidatoFO = ind.calculaDistanciaTotal(distanciasEuclidianas, solAtual);
                if (candidatoFO.getDistancia() < anteriorFO) {//executando uma validação gulosa com os candidatos
                    anteriorFO = candidatoFO.getDistancia();
                    for (k=0; k<numeroPatios; k++) {
                        melhor[k] = solAtual[k];
                    }
                    resultado.setSolucoesAceitas(resultado.getSolucoesAceitas()+1);
                }
            }
            return melhor;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private int[] construtivaGRASP(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int LRC, double penalizacao, int indiVolumeRenda, double restricaoVolumeRenda, double flexRestricaoVolumeRenda">
    private int[] construtivaGRASP(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int LRC, 
            double penalizacao, int indiVolumeRenda, double restricaoVolumeRenda, double flexRestricaoVolumeRenda) throws Exception {
        try {
            //instanciando a classe random
            Random gerador = new Random();
            
            int qtdeElementos = listaIndividuo.size();
            int ListaRC[] = new int[LRC];
            int candidato, i, j, k;
            double anteriorFO = Double.POSITIVE_INFINITY; //vetor para armazenar os valores das FOs dos pátios
            ResultadoDistancia candidatoFO;
            int solAtual[] = new int[numeroPatios];
            int melhor[] = new int[numeroPatios];            

            //criando lista de validação de candidatos
            int candidatos[] = new int[qtdeElementos]; //lista de candidatos que ainda não foram selecionados
            //inicializando o vetor solAtual
            for (i=0; i<qtdeElementos; i++)
                candidatos[i] = 0;

            //gerando a lista restritiva de candidatos
            for (i=0; i<LRC; i++) {
                //garantindo que nenhum candidato escolhido seja repetido
                do {
                    //obtendo uma árvore aleatoriamente para considerar como candidato
                    candidato = gerador.nextInt(qtdeElementos)+1;
                } while (candidatos[candidato-1] == 1);
                
                candidatos[candidato-1] = 1;
                ListaRC[i] = candidato;
            }
            
            //avaliando as combinações entre os candidatos
            for (i=0; i<(ListaRC.length-numeroPatios); i++) {
                resultado.setIteracoes(resultado.getIteracoes()+1);
                resultado.setSolucoesViaveis(resultado.getSolucoesViaveis()+1);
                for (j=i; j<(i+numeroPatios); j++) {
                    //preenchendo a solução atual para calcular a FO
                    solAtual[j-i] = ListaRC[j];
                }
                //calculando FO da solução atual e validando
                candidatoFO = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, solAtual, indiVolumeRenda, restricaoVolumeRenda, flexRestricaoVolumeRenda, penalizacao);
                if (candidatoFO.getDistancia() < anteriorFO) {//executando uma validação gulosa com os candidatos
                    anteriorFO = candidatoFO.getDistancia();
                    for (k=0; k<numeroPatios; k++) {
                        melhor[k] = solAtual[k];
                    }
                    resultado.setSolucoesAceitas(resultado.getSolucoesAceitas()+1);
                }
            }
            return melhor;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="private int[] construtivaGRASP(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, int numeroPatios, int LRC, double penalizacao, double restricaoVolume, double flexRestricaoVolume, double restricaoRenda, double flexRestricaoRenda)">
    private int[] construtivaGRASP(double[][] distanciasEuclidianas, ArrayList<Individuo> listaIndividuo, 
            int numeroPatios, int LRC, double penalizacao, double restricaoVolume, double flexRestricaoVolume, 
            double restricaoRenda, double flexRestricaoRenda) throws Exception {
        try {
            //instanciando a classe random
            Random gerador = new Random();
            
            int qtdeElementos = listaIndividuo.size();
            int ListaRC[] = new int[LRC];
            int candidato, i, j, k;
            double anteriorFO = Double.POSITIVE_INFINITY; //vetor para armazenar os valores das FOs dos pátios
            ResultadoDistancia candidatoFO;
            int solAtual[] = new int[numeroPatios];
            int melhor[] = new int[numeroPatios];            

            //criando lista de validação de candidatos
            int candidatos[] = new int[qtdeElementos]; //lista de candidatos que ainda não foram selecionados
            //inicializando o vetor solAtual
            for (i=0; i<qtdeElementos; i++)
                candidatos[i] = 0;

            //gerando a lista restritiva de candidatos
            for (i=0; i<LRC; i++) {
                //garantindo que nenhum candidato escolhido seja repetido
                do {
                    //obtendo uma árvore aleatoriamente para considerar como candidato
                    candidato = gerador.nextInt(qtdeElementos)+1;
                } while (candidatos[candidato-1] == 1);
                
                candidatos[candidato-1] = 1;
                ListaRC[i] = candidato;
            }
            
            //avaliando as combinações entre os candidatos
            for (i=0; i<(ListaRC.length-numeroPatios); i++) {
                resultado.setIteracoes(resultado.getIteracoes()+1);
                resultado.setSolucoesViaveis(resultado.getSolucoesViaveis()+1);
                for (j=i; j<(i+numeroPatios); j++) {
                    //preenchendo a solução atual para calcular a FO
                    solAtual[j-i] = ListaRC[j];
                }
                //calculando FO da solução atual e validando
                candidatoFO = ind.calculaDistanciaTotal(distanciasEuclidianas, listaIndividuo, solAtual, 
                        restricaoVolume, flexRestricaoVolume, restricaoRenda, flexRestricaoRenda, penalizacao);
                if (candidatoFO.getDistancia() < anteriorFO) {//executando uma validação gulosa com os candidatos
                    anteriorFO = candidatoFO.getDistancia();
                    for (k=0; k<numeroPatios; k++) {
                        melhor[k] = solAtual[k];
                    }
                    resultado.setSolucoesAceitas(resultado.getSolucoesAceitas()+1);
                }
            }
            return melhor;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
    //</editor-fold>

}
