/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.FO;
import classes.Instancia;
import classes.Patio;
import classes.Solucao;
import java.util.Random;

public class Vizinho {
    private Random gerador;
    private FO classFO;
    private int[] patiosSel;
    private int[] patiosGrau;

    public Vizinho(Instancia instancia) {
        this.inicializaPatiosSel(instancia);
        this.inicializaPatiosGrau(instancia);
        this.gerador = new Random();
        this.classFO = new FO();
    }

    private void inicializaPatiosSel(Instancia instancia) {
        this.patiosSel = new int[instancia.getQtdePatios()];
        for (int i = 0; i < instancia.getQtdePatios(); ++i) {
            this.patiosSel[i] = 0;
        }
    }

    private void inicializaPatiosGrau(Instancia instancia) {
        this.patiosGrau = new int[instancia.getQtdePatios()];
        for (int i = 0; i < instancia.getQtdePatios(); ++i) {
            this.patiosGrau[i] = 0;
        }
    }

    private void limpaPatiosSel(Instancia instancia) {
        for (int i = 0; i < instancia.getQtdePatios(); ++i) {
            this.patiosSel[i] = 0;
        }
    }

    private void limpaPatiosGrau(Instancia instancia) {
        for (int i = 0; i < instancia.getQtdePatios(); ++i) {
            this.patiosGrau[i] = 0;
        }
    }

    private void marcaPatiosSel(Solucao sol) {
        for (Patio patio : sol.getPatios()) {
            this.patiosSel[patio.getId() - 1] = 1;
        }
    }

    private void marcaPatioGrau(int patio) {
        this.patiosGrau[patio - 1] = 1;
    }

    public Solucao gerarVizinho(Instancia instancia, Solucao atual) throws Exception {
        try {
            int vizinho;
            Solucao solAtual = new Solucao();
            solAtual = solAtual.aceita(atual);
            this.limpaPatiosSel(instancia);
            this.marcaPatiosSel(solAtual);
            int troca = this.gerador.nextInt(solAtual.getPatios().size());
            while (this.patiosSel[vizinho = this.gerador.nextInt(instancia.getQtdePatios())] == 1) {
            }
            solAtual.getPatios().set(troca, instancia.getListaPatio().get(vizinho));
            this.patiosSel[vizinho] = 1;
            solAtual = this.classFO.alocaArvoresPatio(instancia, solAtual);
            solAtual = this.classFO.calculaFO(instancia, solAtual);
            return solAtual;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Solucao gerarVizinhoPatioFixo(Instancia instancia, Solucao atual, int k) throws Exception {
        try {
            int vizinho;
            Solucao solAtual = new Solucao();
            solAtual = solAtual.aceita(atual);
            this.limpaPatiosSel(instancia);
            this.marcaPatiosSel(solAtual);
            int patio = k % solAtual.getPatios().size();
            do {
                vizinho = this.gerador.nextInt(instancia.getQtdePatios());
                solAtual.getPatios().set(patio, instancia.getListaPatio().get(vizinho));
            } while (this.patiosSel[vizinho] == 1);
            this.patiosSel[vizinho] = 1;
            solAtual = this.classFO.alocaArvoresPatio(instancia, solAtual);
            solAtual = this.classFO.calculaFO(instancia, solAtual);
            return solAtual;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Solucao gerarVizinhoV2(Instancia instancia, Solucao atual) throws Exception {
        try {
            int vizinho;
            Solucao solAtual = new Solucao();
            solAtual = solAtual.aceita(atual);
            int caminho = 0;
            this.limpaPatiosSel(instancia);
            this.marcaPatiosSel(solAtual);
            int troca = this.gerador.nextInt(solAtual.getPatios().size());
            int direcao = this.gerador.nextInt(2);
            do {
                if ((vizinho = direcao == 0 ? solAtual.getPatios().get(troca).getId() - caminho : solAtual.getPatios().get(troca).getId() + ++caminho) >= 0 && vizinho < instancia.getQtdePatios()) continue;
                vizinho = this.gerador.nextInt(instancia.getQtdePatios());
            } while (this.patiosSel[vizinho] == 1);
            solAtual.getPatios().set(troca, instancia.getListaPatio().get(vizinho));
            this.patiosSel[vizinho] = 1;
            solAtual = this.classFO.alocaArvoresPatio(instancia, solAtual);
            solAtual = this.classFO.calculaFO(instancia, solAtual);
            return solAtual;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Solucao gerarVizinhoV3(Instancia instancia, Solucao atual) throws Exception {
        try {
            Solucao solAtual = new Solucao();
            solAtual = solAtual.aceita(atual);
            int caminho = 1;
            boolean direcao = false;
            this.limpaPatiosSel(instancia);
            this.marcaPatiosSel(solAtual);
            int troca = this.gerador.nextInt(solAtual.getPatios().size());
            int patio = solAtual.getPatios().get(troca).getId();
            int vizinho = patio + 1;
            solAtual.getPatios().set(troca, instancia.getListaPatio().get(vizinho));
            solAtual = this.classFO.alocaArvoresPatio(instancia, solAtual);
            solAtual = this.classFO.calculaFO(instancia, solAtual);
            double FOSoma = solAtual.getFO();
            vizinho = patio - 1;
            solAtual.getPatios().set(troca, instancia.getListaPatio().get(vizinho));
            solAtual = this.classFO.alocaArvoresPatio(instancia, solAtual);
            solAtual = this.classFO.calculaFO(instancia, solAtual);
            double FOSub = solAtual.getFO();
            if (FOSoma < FOSub) {
                direcao = true;
            }
            boolean melhorou = true;
            while (melhorou) {
                melhorou = false;
                double FOAnterior = solAtual.getFO();
                do {
                    if ((vizinho = !direcao ? solAtual.getPatios().get(troca).getId() - caminho : solAtual.getPatios().get(troca).getId() + ++caminho) >= 0 && vizinho < instancia.getQtdePatios()) continue;
                    vizinho = this.gerador.nextInt(instancia.getQtdePatios());
                } while (this.patiosSel[vizinho] == 1);
                solAtual.getPatios().set(troca, instancia.getListaPatio().get(vizinho));
                this.patiosSel[vizinho] = 1;
                solAtual = this.classFO.alocaArvoresPatio(instancia, solAtual);
                if (!((solAtual = this.classFO.calculaFO(instancia, solAtual)).getFO() < FOAnterior)) continue;
                melhorou = true;
            }
            return solAtual;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Solucao gerarVizinhoGrau(Instancia instancia, Solucao atual, int grau) throws Exception {
        try {
            int vizinho;
            Solucao solAtual = new Solucao();
            solAtual = solAtual.aceita(atual);
            this.limpaPatiosSel(instancia);
            this.limpaPatiosGrau(instancia);
            this.marcaPatiosSel(solAtual);
            int troca = this.gerador.nextInt(solAtual.getPatios().size());
            int patio = solAtual.getPatios().get(troca).getId();
            this.marcaVizinhos(instancia, patio, 1, grau);
            while (this.patiosSel[vizinho = this.gerador.nextInt(instancia.getQtdePatios())] == 1 && this.patiosGrau[vizinho] != 1) {
            }
            solAtual.getPatios().set(troca, instancia.getListaPatio().get(vizinho));
            this.patiosSel[vizinho] = 1;
            solAtual = this.classFO.alocaArvoresPatio(instancia, solAtual);
            solAtual = this.classFO.calculaFO(instancia, solAtual);
            return solAtual;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Solucao gerarVizinhoGrauV2(Instancia instancia, Solucao atual, int patios) throws Exception {
        try {
            Solucao solAtual = new Solucao();
            solAtual = solAtual.aceita(atual);
            this.limpaPatiosSel(instancia);
            this.marcaPatiosSel(solAtual);
            for (int i = 0; i < patios; ++i) {
                int j;
                int vizinho;
                int troca = this.gerador.nextInt(solAtual.getPatios().size());
                int patio = solAtual.getPatios().get(troca).getId();
                do {
                    j = this.gerador.nextInt(20) + 1;
                } while (this.patiosSel[(vizinho = instancia.getListaPatio().get(instancia.getOrdemDistanciasPatioPatios()[patio - 1][j]).getId()) - 1] == 1);
                solAtual.getPatios().set(troca, instancia.getListaPatio().get(vizinho - 1));
                this.patiosSel[vizinho - 1] = 1;
            }
            solAtual = this.classFO.alocaArvoresPatio(instancia, solAtual);
            solAtual = this.classFO.calculaFO(instancia, solAtual);
            return solAtual;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    private void marcaVizinhos(Instancia instancia, int patio, int grauAtual, int grau) throws Exception {
        try {
            if (grauAtual <= grau) {
                for (int i = 1; i < 9; ++i) {
                    int patioAtual = instancia.getListaPatio().get(instancia.getOrdemDistanciasPatioPatios()[patio - 1][i]).getId();
                    this.marcaPatioGrau(patioAtual);
                    this.marcaVizinhos(instancia, patioAtual, grauAtual + 1, grau);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
}

