/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.FO;
import classes.Instancia;
import classes.MetodoBuscaLocal;
import classes.Resultado;
import classes.Solucao;
import classes.Vizinho;
import java.util.ArrayList;

public class VNS {
    private FO classFO = new FO();

    public Resultado vns(Instancia instancia, Solucao solInicial, int vns_r, MetodoBuscaLocal metodoBusca, int MaxIterMelhora) throws Exception {
        try {
            int iteracoes = 0;
            ArrayList<String> relatorio = new ArrayList<String>();
            long tempoInicio = System.currentTimeMillis();
            long tempoTermino = tempoInicio + instancia.getTempoExecucao() * 60000L;
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            Vizinho viz = new Vizinho(instancia);
            Resultado res = new Resultado();
            Solucao melhorSol = new Solucao();
            melhorSol = melhorSol.aceita(solInicial);
            while (System.currentTimeMillis() < tempoTermino) {
                int k = 1;
                while (k <= vns_r && System.currentTimeMillis() < tempoTermino) {
                    String rel;
                    ++iteracoes;
                    Solucao solVizinha = viz.gerarVizinho(instancia, melhorSol);
                    Solucao atualSol = metodoBusca.buscaLocal(instancia, solVizinha, MaxIterMelhora);
                    if (!atualSol.isViavel()) {
                        atualSol = this.classFO.realocarArvoresPatio(instancia, atualSol);
                    }
                    if (atualSol.isViavel()) {
                        ++qtdeSolucoesViaveis;
                        rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - vi\u00e1vel ";
                    } else {
                        rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - invi\u00e1vel ";
                    }
                    relatorio.add(rel);
                    if (atualSol.getFO() < melhorSol.getFO()) {
                        melhorSol = melhorSol.aceita(atualSol);
                        res.setTempoSol(System.currentTimeMillis() - tempoInicio);
                        ++qtdeSolucoesAceitas;
                        k = 1;
                        continue;
                    }
                    ++k;
                }
            }
            if (!melhorSol.isViavel() && (melhorSol = this.classFO.realocarArvoresPatio(instancia, melhorSol)).isViavel()) {
                ++qtdeSolucoesViaveis;
            }
            res.setSolucao(melhorSol);
            res.setIteracoes(iteracoes);
            res.setSolucoesViaveis(qtdeSolucoesViaveis);
            res.setSolucoesAceitas(qtdeSolucoesAceitas);
            res.setTempoDecorrido(System.currentTimeMillis() - tempoInicio);
            res.setRelatorio(relatorio);
            return res;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Resultado vnsED(Instancia instancia, Solucao solInicial, int vns_r, MetodoBuscaLocal metodoBusca, int MaxIterMelhora) throws Exception {
        try {
            int iteracoes = 0;
            ArrayList<String> relatorio = new ArrayList<String>();
            long tempoInicio = System.currentTimeMillis();
            long tempoTermino = tempoInicio + instancia.getTempoExecucao() * 60000L;
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            Vizinho viz = new Vizinho(instancia);
            Resultado res = new Resultado();
            Solucao melhorSol = new Solucao();
            melhorSol = melhorSol.aceita(solInicial);
            while (System.currentTimeMillis() < tempoTermino) {
                int k = 1;
                while (k <= vns_r && System.currentTimeMillis() < tempoTermino) {
                    String rel;
                    Solucao solVizinha;
                    ++iteracoes;
                    switch (k) {
                        case 1: {
                            solVizinha = viz.gerarVizinhoGrau(instancia, melhorSol, 4);
                            break;
                        }
                        case 2: {
                            solVizinha = viz.gerarVizinho(instancia, melhorSol);
                            break;
                        }
                        case 3: {
                            solVizinha = viz.gerarVizinhoV2(instancia, melhorSol);
                            break;
                        }
                        case 4: {
                            solVizinha = viz.gerarVizinhoGrauV2(instancia, melhorSol, 3);
                            break;
                        }
                        case 5: {
                            solVizinha = viz.gerarVizinhoPatioFixo(instancia, melhorSol, k);
                            break;
                        }
                        case 6: {
                            solVizinha = viz.gerarVizinhoV3(instancia, melhorSol);
                            break;
                        }
                        default: {
                            solVizinha = viz.gerarVizinho(instancia, melhorSol);
                        }
                    }
                    Solucao atualSol = metodoBusca.buscaLocal(instancia, solVizinha, MaxIterMelhora);
                    if (!atualSol.isViavel()) {
                        atualSol = this.classFO.realocarArvoresPatio(instancia, atualSol);
                    }
                    if (atualSol.isViavel()) {
                        ++qtdeSolucoesViaveis;
                        rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - vi\u00e1vel ";
                    } else {
                        rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - invi\u00e1vel ";
                    }
                    relatorio.add(rel);
                    if (atualSol.getFO() < melhorSol.getFO()) {
                        melhorSol = melhorSol.aceita(atualSol);
                        res.setTempoSol(System.currentTimeMillis() - tempoInicio);
                        ++qtdeSolucoesAceitas;
                        k = 1;
                        continue;
                    }
                    ++k;
                }
            }
            if (!melhorSol.isViavel() && (melhorSol = this.classFO.realocarArvoresPatio(instancia, melhorSol)).isViavel()) {
                ++qtdeSolucoesViaveis;
            }
            res.setSolucao(melhorSol);
            res.setIteracoes(iteracoes);
            res.setSolucoesViaveis(qtdeSolucoesViaveis);
            res.setSolucoesAceitas(qtdeSolucoesAceitas);
            res.setTempoDecorrido(System.currentTimeMillis() - tempoInicio);
            res.setRelatorio(relatorio);
            return res;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
}

