/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.FO;
import classes.Instancia;
import classes.Patio;
import classes.Resultado;
import classes.Solucao;
import java.util.ArrayList;

public class TS {
    private FO classFO = new FO();
    private int[] patiosSel;
    private int[][] listaT;

    private void inicializaPatiosSel(Instancia instancia) {
        this.patiosSel = new int[instancia.getQtdePatios()];
        for (int i = 0; i < instancia.getQtdePatios(); ++i) {
            this.patiosSel[i] = 0;
        }
    }

    private void limpaPatiosSel(Instancia instancia) {
        for (int i = 0; i < instancia.getQtdePatios(); ++i) {
            this.patiosSel[i] = 0;
        }
    }

    private void marcaPatiosSel(Solucao sol) {
        for (Patio patio : sol.getPatios()) {
            this.patiosSel[patio.getId() - 1] = 1;
        }
    }

    private void inicializaListaTabu(Instancia instancia, int T) {
        this.listaT = new int[T][instancia.getPatiosNecessarios()];
        for (int i = 0; i < T; ++i) {
            this.listaT[i][0] = -1;
        }
    }

    private boolean consultaListaTabu(Solucao sol, int T) {
        boolean existe = false;
        for (int i = 0; i < T && this.listaT[i][0] != -1; ++i) {
            boolean continua;
            int j = 0;
            block1: do {
                continua = false;
                for (int k = 0; k < sol.getPatios().size(); ++k) {
                    if (sol.getPatios().get(j).getId() != this.listaT[i][k]) continue;
                    continua = true;
                    continue block1;
                }
            } while (continua && ++j < sol.getPatios().size());
            if (j != sol.getPatios().size() || !continua) continue;
            existe = true;
            break;
        }
        return existe;
    }

    private void insereListaTabu(Solucao sol, int T) {
        int i;
        int pos = 0;
        for (i = 0; i < T && this.listaT[i][0] != -1; ++i) {
            if (++pos != T) continue;
            pos = 0;
            break;
        }
        for (i = 0; i < sol.getPatios().size(); ++i) {
            this.listaT[pos][i] = sol.getPatios().get(i).getId();
        }
    }

    private Solucao obtemElemListaTabu(Instancia instancia, int elem) throws Exception {
        Solucao res = new Solucao();
        for (int i = 0; i < instancia.getPatiosNecessarios(); ++i) {
            res.addPatio(instancia.getListaPatio().get(this.listaT[elem][i - 1]));
        }
        return res;
    }

    public Resultado buscaTabu(Instancia instancia, Solucao solInicial, int BTmax, int T) throws Exception {
        try {
            ArrayList<String> relatorio = new ArrayList<String>();
            long tempoInicio = System.currentTimeMillis();
            long tempoTermino = tempoInicio + instancia.getTempoExecucao() * 60000L;
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            int iteracoes = 0;
            this.inicializaListaTabu(instancia, T);
            this.inicializaPatiosSel(instancia);
            Resultado res = new Resultado();
            Solucao melhorSol = new Solucao();
            melhorSol = melhorSol.aceita(solInicial);
            Solucao atualSol = new Solucao();
            atualSol = atualSol.aceita(melhorSol);
            boolean aspirou = false;
            double mFO = Double.POSITIVE_INFINITY;
            while (System.currentTimeMillis() < tempoTermino) {
                int mPos = -1;
                int mPat = -1;
                this.limpaPatiosSel(instancia);
                this.marcaPatiosSel(atualSol);
                for (int i = 0; i < instancia.getPatiosNecessarios() && System.currentTimeMillis() < tempoTermino; ++i) {
                    int patioOld = atualSol.getPatios().get(i).getId();
                    int k = 1;
                    int j = 0;
                    while (k <= BTmax && j < instancia.getQtdePatios()) {
                        if (this.patiosSel[j] != 1) {
                            String rel;
                            aspirou = false;
                            Patio patio = instancia.getListaPatio().get(j);
                            atualSol.getPatios().set(i, patio);
                            atualSol = this.classFO.alocaArvoresPatio(instancia, atualSol);
                            atualSol = this.classFO.calculaFO(instancia, atualSol);
                            if (atualSol.isViavel()) {
                                ++qtdeSolucoesViaveis;
                                rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - vi\u00e1vel ";
                            } else {
                                rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - invi\u00e1vel ";
                            }
                            relatorio.add(rel);
                            boolean existe = this.consultaListaTabu(atualSol, T);
                            if (existe) {
                                if (atualSol.getFO() < melhorSol.getFO()) {
                                    mPat = j;
                                    mPos = i;
                                    mFO = atualSol.getFO();
                                    aspirou = true;
                                    k = 1;
                                } else {
                                    ++k;
                                }
                            } else if (atualSol.getFO() < mFO) {
                                mPat = j;
                                mPos = i;
                                mFO = atualSol.getFO();
                                k = 1;
                            } else {
                                ++k;
                            }
                            atualSol.getPatios().set(i, instancia.getListaPatio().get(patioOld - 1));
                        }
                        ++j;
                        ++iteracoes;
                    }
                }
                if (mPat != -1) {
                    atualSol.getPatios().set(mPos, instancia.getListaPatio().get(mPat));
                    atualSol = this.classFO.alocaArvoresPatio(instancia, atualSol);
                    atualSol = this.classFO.calculaFO(instancia, atualSol);
                    if (!atualSol.isViavel()) {
                        atualSol = this.classFO.realocarArvoresPatio(instancia, atualSol);
                    }
                    if (!aspirou) {
                        this.insereListaTabu(atualSol, T);
                    }
                } else {
                    atualSol = this.obtemElemListaTabu(instancia, 0);
                    atualSol = this.classFO.alocaArvoresPatio(instancia, atualSol);
                    atualSol = this.classFO.calculaFO(instancia, atualSol);
                }
                if (!(atualSol.getFO() < melhorSol.getFO())) continue;
                melhorSol = melhorSol.aceita(atualSol);
                res.setTempoSol(System.currentTimeMillis() - tempoInicio);
                ++qtdeSolucoesAceitas;
            }
            if (!melhorSol.isViavel() && (melhorSol = this.classFO.realocarArvoresPatio(instancia, melhorSol)).isViavel()) {
                ++qtdeSolucoesViaveis;
            }
            res.setSolucao(melhorSol);
            res.setIteracoes(iteracoes);
            res.setSolucoesViaveis(qtdeSolucoesViaveis);
            res.setSolucoesAceitas(qtdeSolucoesAceitas);
            res.setTempoDecorrido(System.currentTimeMillis() - tempoInicio);
            res.setRelatorio(relatorio);
            return res;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Resultado buscaTabuV2(Instancia instancia, Solucao solInicial, int BTmax, int T) throws Exception {
        try {
            ArrayList<String> relatorio = new ArrayList<String>();
            long tempoInicio = System.currentTimeMillis();
            long tempoTermino = tempoInicio + instancia.getTempoExecucao() * 60000L;
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            int iteracoes = 0;
            this.inicializaListaTabu(instancia, T);
            this.inicializaPatiosSel(instancia);
            Resultado res = new Resultado();
            Solucao melhorSol = new Solucao();
            melhorSol = melhorSol.aceita(solInicial);
            Solucao atualSol = new Solucao();
            atualSol = atualSol.aceita(melhorSol);
            boolean aspirou = false;
            while (System.currentTimeMillis() < tempoTermino) {
                double mFO = Double.POSITIVE_INFINITY;
                int mPos = -1;
                int mPat = -1;
                this.marcaPatiosSel(atualSol);
                for (int i = 0; i < instancia.getPatiosNecessarios() && System.currentTimeMillis() < tempoTermino; ++i) {
                    int patioOld = atualSol.getPatios().get(i).getId();
                    int k = 1;
                    int j = 0;
                    while (k <= BTmax && j < instancia.getQtdePatios()) {
                        if (this.patiosSel[j] != 1) {
                            String rel;
                            aspirou = false;
                            Patio patio = instancia.getListaPatio().get(j);
                            atualSol.getPatios().set(i, patio);
                            atualSol = this.classFO.alocaArvoresPatio(instancia, atualSol);
                            atualSol = this.classFO.calculaFO(instancia, atualSol);
                            if (atualSol.isViavel()) {
                                ++qtdeSolucoesViaveis;
                                rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - vi\u00e1vel ";
                            } else {
                                rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - invi\u00e1vel ";
                            }
                            relatorio.add(rel);
                            boolean existe = this.consultaListaTabu(atualSol, T);
                            if (existe) {
                                if (atualSol.getFO() < melhorSol.getFO()) {
                                    mPat = j;
                                    mPos = i;
                                    mFO = atualSol.getFO();
                                    aspirou = true;
                                    k = 1;
                                } else {
                                    ++k;
                                }
                            } else if (atualSol.getFO() < mFO) {
                                mPat = j;
                                mPos = i;
                                mFO = atualSol.getFO();
                                k = 1;
                            } else {
                                ++k;
                            }
                            atualSol.getPatios().set(i, instancia.getListaPatio().get(patioOld - 1));
                        }
                        ++j;
                        ++iteracoes;
                    }
                }
                if (mPat != -1) {
                    atualSol.getPatios().set(mPos, instancia.getListaPatio().get(mPat));
                    atualSol = this.classFO.alocaArvoresPatio(instancia, atualSol);
                    atualSol = this.classFO.calculaFO(instancia, atualSol);
                    if (!atualSol.isViavel()) {
                        atualSol = this.classFO.realocarArvoresPatio(instancia, atualSol);
                    }
                    if (!aspirou) {
                        this.insereListaTabu(atualSol, T);
                    }
                } else {
                    atualSol = this.obtemElemListaTabu(instancia, 0);
                    atualSol = this.classFO.alocaArvoresPatio(instancia, atualSol);
                    atualSol = this.classFO.calculaFO(instancia, atualSol);
                }
                if (!(atualSol.getFO() < melhorSol.getFO())) continue;
                melhorSol = melhorSol.aceita(atualSol);
                res.setTempoSol(System.currentTimeMillis() - tempoInicio);
                ++qtdeSolucoesAceitas;
            }
            if (!melhorSol.isViavel() && (melhorSol = this.classFO.realocarArvoresPatio(instancia, melhorSol)).isViavel()) {
                ++qtdeSolucoesViaveis;
            }
            res.setSolucao(melhorSol);
            res.setIteracoes(iteracoes);
            res.setSolucoesViaveis(qtdeSolucoesViaveis);
            res.setSolucoesAceitas(qtdeSolucoesAceitas);
            res.setTempoDecorrido(System.currentTimeMillis() - tempoInicio);
            res.setRelatorio(relatorio);
            return res;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
}

