/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.FO;
import classes.HeuConstrutiva;
import classes.Instancia;
import classes.Resultado;
import classes.Solucao;
import classes.Vizinho;
import java.util.ArrayList;
import java.util.Random;

public class SA {
    private FO classFO;
    private Random gerador;
    private final double euler = Math.E;

    public SA() {
        this.classFO = new FO();
        this.gerador = new Random();
    }

    public Resultado simulatedAnnealing(Instancia instancia, double txResfriamento, int iteracoesVizinhanca, double tempInicial, double tempCongelamento, Solucao solInicial) throws Exception {
        try {
            ArrayList<String> relatorio = new ArrayList<String>();
            long tempoInicio = System.currentTimeMillis();
            long tempoTermino = tempoInicio + instancia.getTempoExecucao() * 60000L;
            int iteracoes = 0;
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            Resultado res = new Resultado();
            Solucao melhorSol = new Solucao();
            melhorSol = melhorSol.aceita(solInicial);
            Vizinho viz = new Vizinho(instancia);
            int IterTemp = 0;
            double temp = tempInicial;
            while (temp > tempCongelamento && System.currentTimeMillis() < tempoTermino) {
                while (IterTemp < iteracoesVizinhanca && System.currentTimeMillis() < tempoTermino) {
                    String rel;
                    ++iteracoes;
                    ++IterTemp;
                    Solucao vizinho = viz.gerarVizinho(instancia, solInicial);
                    double variacao = vizinho.getFO() - solInicial.getFO();
                    if (vizinho.isViavel()) {
                        ++qtdeSolucoesViaveis;
                        rel = "FO: " + String.valueOf(vizinho.getFO() / (double)instancia.getQtdeArvores()) + " - vi\u00e1vel ";
                    } else {
                        rel = "FO: " + String.valueOf(vizinho.getFO() / (double)instancia.getQtdeArvores()) + " - invi\u00e1vel ";
                    }
                    relatorio.add(rel);
                    if (variacao < 0.0) {
                        ++qtdeSolucoesAceitas;
                        solInicial = solInicial.aceita(vizinho);
                        if (!(vizinho.getFO() < melhorSol.getFO())) continue;
                        melhorSol = melhorSol.aceita(vizinho);
                        res.setTempoSol(System.currentTimeMillis() - tempoInicio);
                        continue;
                    }
                    double x = this.gerador.nextFloat() % 1001.0f;
                    if (!((x /= 1000.0) < Math.pow(Math.E, -variacao / temp))) continue;
                    ++qtdeSolucoesAceitas;
                    solInicial = solInicial.aceita(vizinho);
                }
                if ((temp = txResfriamento * temp) < tempCongelamento + tempCongelamento * 2.0 && System.currentTimeMillis() < tempoTermino) {
                    temp = tempInicial;
                }
                IterTemp = 0;
            }
            res.setSolucao(melhorSol);
            res.setIteracoes(iteracoes);
            res.setSolucoesViaveis(qtdeSolucoesViaveis);
            res.setSolucoesAceitas(qtdeSolucoesAceitas);
            res.setTempoDecorrido(System.currentTimeMillis() - tempoInicio);
            res.setRelatorio(relatorio);
            return res;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Resultado simulatedAnnealingPE(Instancia instancia, double txResfriamento, int iteracoesVizinhanca, double tempInicial, double tempCongelamento, Solucao solInicial) throws Exception {
        try {
            ArrayList<String> relatorio = new ArrayList<String>();
            long tempoInicio = System.currentTimeMillis();
            long tempoTermino = tempoInicio + instancia.getTempoExecucao() * 60000L;
            int iteracoes = 0;
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            Resultado res = new Resultado();
            Solucao melhorSol = new Solucao();
            HeuConstrutiva hc = new HeuConstrutiva();
            melhorSol = melhorSol.aceita(solInicial);
            Vizinho viz = new Vizinho(instancia);
            int iterSemMelhora = 0;
            int IterTemp = 0;
            double temp = tempInicial;
            while (temp > tempCongelamento && System.currentTimeMillis() < tempoTermino) {
                while (IterTemp < iteracoesVizinhanca && System.currentTimeMillis() < tempoTermino) {
                    String rel;
                    ++iteracoes;
                    ++IterTemp;
                    Solucao vizinho = viz.gerarVizinho(instancia, solInicial);
                    double variacao = vizinho.getFO() - solInicial.getFO();
                    if (vizinho.isViavel()) {
                        ++qtdeSolucoesViaveis;
                        rel = "FO: " + String.valueOf(vizinho.getFO() / (double)instancia.getQtdeArvores()) + " - vi\u00e1vel ";
                    } else {
                        rel = "FO: " + String.valueOf(vizinho.getFO() / (double)instancia.getQtdeArvores()) + " - invi\u00e1vel ";
                    }
                    relatorio.add(rel);
                    if (variacao < 0.0) {
                        iterSemMelhora = 0;
                        ++qtdeSolucoesAceitas;
                        solInicial = solInicial.aceita(vizinho);
                        if (!(vizinho.getFO() < melhorSol.getFO())) continue;
                        melhorSol = melhorSol.aceita(vizinho);
                        res.setTempoSol(System.currentTimeMillis() - tempoInicio);
                        continue;
                    }
                    ++iterSemMelhora;
                    double x = this.gerador.nextFloat() % 1001.0f;
                    if ((x /= 1000.0) < Math.pow(Math.E, -variacao / temp)) {
                        ++qtdeSolucoesAceitas;
                        solInicial = solInicial.aceita(vizinho);
                        continue;
                    }
                    if (iterSemMelhora < 800) continue;
                    System.out.println("entrou perturba\u00e7\u00e3o");
                    Solucao solPertuba = hc.obterSolAleatoria(instancia);
                    solInicial = solInicial.aceita(solPertuba);
                    iterSemMelhora = 0;
                }
                if ((temp = txResfriamento * temp) < tempCongelamento + tempCongelamento * 2.0 && System.currentTimeMillis() < tempoTermino) {
                    temp = tempInicial;
                }
                IterTemp = 0;
            }
            res.setSolucao(melhorSol);
            res.setIteracoes(iteracoes);
            res.setSolucoesViaveis(qtdeSolucoesViaveis);
            res.setSolucoesAceitas(qtdeSolucoesAceitas);
            res.setTempoDecorrido(System.currentTimeMillis() - tempoInicio);
            res.setRelatorio(relatorio);
            return res;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
}

