/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.FO;
import classes.Instancia;
import classes.Patio;
import classes.Resultado;
import classes.Solucao;
import java.util.ArrayList;
import java.util.Random;

public class HeuConstrutiva {
    private FO classFO = new FO();

    public Solucao obterSolAleatoria(Instancia instancia) throws Exception {
        int i;
        int[] allPatios = new int[instancia.getQtdePatios()];
        for (i = 0; i < instancia.getQtdePatios(); ++i) {
            allPatios[i] = 0;
        }
        Random gerador = new Random();
        Solucao sol = new Solucao();
        for (i = 0; i < instancia.getPatiosNecessarios(); ++i) {
            int iPatio;
            while (allPatios[(iPatio = 1 + gerador.nextInt(instancia.getQtdePatios())) - 1] == 1) {
            }
            allPatios[iPatio - 1] = 1;
            Patio pPatioNovo = instancia.getListaPatio().get(iPatio - 1);
            sol.addPatio(pPatioNovo);
        }
        sol = this.classFO.alocaArvoresPatio(instancia, sol);
        sol = this.classFO.calculaFO(instancia, sol);
        return sol;
    }

    public Solucao obterSolSistematica(Instancia instancia) throws Exception {
        int i;
        int[] allPatios = new int[instancia.getQtdePatios()];
        double distancia = instancia.getDistanciaMaximaArraste() * 2.0 - instancia.getFlexDistancia() * (instancia.getDistanciaMaximaArraste() * 2.0) / 100.0;
        for (i = 0; i < instancia.getQtdePatios(); ++i) {
            allPatios[i] = 0;
        }
        Random gerador = new Random();
        Solucao sol = new Solucao();
        for (i = 0; i < instancia.getPatiosNecessarios(); ++i) {
            boolean viavel;
            int iPatio;
            block2: do {
                viavel = true;
                iPatio = 1 + gerador.nextInt(instancia.getQtdePatios());
                for (int j = 0; j < instancia.getQtdePatios(); ++j) {
                    double distPatios;
                    if (j == iPatio - 1 || allPatios[j] != 1 || !((distPatios = instancia.getDistanciasPatios()[i][j]) < distancia)) continue;
                    viavel = false;
                    continue block2;
                }
            } while (allPatios[iPatio - 1] == 1 && !viavel);
            allPatios[iPatio - 1] = 1;
            Patio pPatioNovo = instancia.getListaPatio().get(iPatio - 1);
            sol.addPatio(pPatioNovo);
        }
        sol = this.classFO.alocaArvoresPatio(instancia, sol);
        sol = this.classFO.calculaFO(instancia, sol);
        return sol;
    }

    public Resultado heuristicaConstrutiva(Instancia instancia, int numeroIteracoes) throws Exception {
        try {
            ArrayList<String> relatorio = new ArrayList<String>();
            long tempoInicio = System.currentTimeMillis();
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            Resultado res = new Resultado();
            Solucao melhorSol = new Solucao();
            melhorSol.setFO(Double.POSITIVE_INFINITY);
            for (int i = 0; i < numeroIteracoes; ++i) {
                String rel;
                Solucao atualSol = this.obterSolAleatoria(instancia);
                if (atualSol.isViavel()) {
                    ++qtdeSolucoesViaveis;
                    rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - vi\u00e1vel ";
                } else {
                    rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - invi\u00e1vel ";
                }
                relatorio.add(rel);
                if (!(atualSol.getFO() < melhorSol.getFO())) continue;
                melhorSol = melhorSol.aceita(atualSol);
                res.setTempoSol(System.currentTimeMillis() - tempoInicio);
                ++qtdeSolucoesAceitas;
            }
            res.setSolucao(melhorSol);
            res.setIteracoes(numeroIteracoes);
            res.setSolucoesViaveis(qtdeSolucoesViaveis);
            res.setSolucoesAceitas(qtdeSolucoesAceitas);
            res.setTempoDecorrido(System.currentTimeMillis() - tempoInicio);
            res.setRelatorio(relatorio);
            return res;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Resultado heuristicaConstrutiva(Instancia instancia) throws Exception {
        try {
            ArrayList<String> relatorio = new ArrayList<String>();
            long tempoInicio = System.currentTimeMillis();
            long tempoTermino = tempoInicio + instancia.getTempoExecucao() * 60000L;
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            int iteracoes = 0;
            Resultado res = new Resultado();
            Solucao melhorSol = new Solucao();
            melhorSol.setFO(Double.POSITIVE_INFINITY);
            while (System.currentTimeMillis() < tempoTermino) {
                String rel;
                ++iteracoes;
                Solucao atualSol = this.obterSolAleatoria(instancia);
                if (atualSol.isViavel()) {
                    ++qtdeSolucoesViaveis;
                    rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - vi\u00e1vel ";
                } else {
                    rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - invi\u00e1vel ";
                }
                relatorio.add(rel);
                if (!(atualSol.getFO() < melhorSol.getFO())) continue;
                melhorSol = melhorSol.aceita(atualSol);
                res.setTempoSol(System.currentTimeMillis() - tempoInicio);
                ++qtdeSolucoesAceitas;
            }
            res.setSolucao(melhorSol);
            res.setIteracoes(iteracoes);
            res.setSolucoesViaveis(qtdeSolucoesViaveis);
            res.setSolucoesAceitas(qtdeSolucoesAceitas);
            res.setTempoDecorrido(System.currentTimeMillis() - tempoInicio);
            res.setRelatorio(relatorio);
            return res;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
}

