/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.FO;
import classes.Instancia;
import classes.MetodoBuscaLocal;
import classes.Resultado;
import classes.Solucao;
import java.util.ArrayList;
import java.util.Random;

public class GRASP {
    private FO classFO = new FO();
    private Random gerador = new Random();

    private int[] obterListaLRC(int qtdePatios, int LRC) {
        int i;
        int nLRC = LRC * qtdePatios / 100;
        int[] ListaRC = new int[nLRC];
        int[] candidatos = new int[qtdePatios];
        for (i = 0; i < qtdePatios; ++i) {
            candidatos[i] = 0;
        }
        for (i = 0; i < nLRC; ++i) {
            int candidato;
            while (candidatos[(candidato = this.gerador.nextInt(qtdePatios) + 1) - 1] == 1) {
            }
            candidatos[candidato - 1] = 1;
            ListaRC[i] = candidato;
        }
        return ListaRC;
    }

    public Resultado GRASP(Instancia instancia, int LRC, MetodoBuscaLocal metodoBusca, int MaxIterMelhora) throws Exception {
        try {
            ArrayList<String> relatorio = new ArrayList<String>();
            long tempoInicio = System.currentTimeMillis();
            long tempoTermino = tempoInicio + instancia.getTempoExecucao() * 60000L;
            int iteracoes = 0;
            Resultado res = new Resultado();
            Solucao melhorSol = new Solucao();
            melhorSol.setFO(Double.POSITIVE_INFINITY);
            int qtdeSolucoesViaveis = 0;
            int qtdeSolucoesAceitas = 0;
            while (System.currentTimeMillis() < tempoTermino) {
                String rel;
                ++iteracoes;
                Solucao atualSol = this.construtivaGRASP(instancia, LRC);
                if (!(atualSol = metodoBusca.buscaLocal(instancia, atualSol, MaxIterMelhora)).isViavel()) {
                    atualSol = this.classFO.realocarArvoresPatio(instancia, atualSol);
                }
                if (atualSol.isViavel()) {
                    ++qtdeSolucoesViaveis;
                    rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - vi\u00e1vel ";
                } else {
                    rel = "FO: " + String.valueOf(atualSol.getFO() / (double)instancia.getQtdeArvores()) + " - invi\u00e1vel ";
                }
                relatorio.add(rel);
                if (!(atualSol.getFO() < melhorSol.getFO())) continue;
                ++qtdeSolucoesAceitas;
                melhorSol = melhorSol.aceita(atualSol);
                res.setTempoSol(System.currentTimeMillis() - tempoInicio);
            }
            if (!melhorSol.isViavel() && (melhorSol = this.classFO.realocarArvoresPatio(instancia, melhorSol)).isViavel()) {
                ++qtdeSolucoesViaveis;
            }
            res.setSolucao(melhorSol);
            res.setIteracoes(iteracoes);
            res.setSolucoesViaveis(qtdeSolucoesViaveis);
            res.setSolucoesAceitas(qtdeSolucoesAceitas);
            res.setTempoDecorrido(System.currentTimeMillis() - tempoInicio);
            res.setRelatorio(relatorio);
            return res;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    private Solucao construtivaGRASP(Instancia instancia, int LRC) throws Exception {
        try {
            int[] ListaRC = this.obterListaLRC(instancia.getQtdePatios(), LRC);
            Solucao atualSol = new Solucao();
            Solucao melhorSol = new Solucao();
            melhorSol.setFO(Double.POSITIVE_INFINITY);
            for (int i = 0; i < ListaRC.length - instancia.getPatiosNecessarios(); ++i) {
                Solucao sol = new Solucao();
                for (int j = i; j < i + instancia.getPatiosNecessarios(); ++j) {
                    sol.addPatio(instancia.getListaPatio().get(ListaRC[j] - 1));
                }
                atualSol.setPatios(sol.getPatios());
                atualSol = this.classFO.alocaArvoresPatio(instancia, atualSol);
                atualSol = this.classFO.calculaFO(instancia, atualSol);
                if (!(atualSol.getFO() < melhorSol.getFO())) continue;
                melhorSol = melhorSol.aceita(atualSol);
            }
            return melhorSol;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
}

