/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Arvore;
import classes.Instancia;
import classes.Patio;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Scanner;

public class Floresta {
    public ArrayList<Arvore> ImportarArvores(String caminho) throws FileNotFoundException, Exception {
        try {
            ArrayList<Arvore> listaArvore = new ArrayList<Arvore>();
            listaArvore.clear();
            Scanner arquivo = new Scanner(new FileReader(caminho));
            arquivo.nextLine();
            while (arquivo.hasNext()) {
                Arvore newArvore = new Arvore();
                newArvore.setId(Integer.parseInt(arquivo.next()));
                newArvore.setUpa(Integer.parseInt(arquivo.next()));
                newArvore.setUt(Integer.parseInt(arquivo.next()));
                newArvore.setCodArvore(Integer.parseInt(arquivo.next()));
                newArvore.setVolumeEq(Double.parseDouble(arquivo.next()));
                arquivo.next();
                newArvore.setX(Double.parseDouble(arquivo.next()));
                newArvore.setY(Double.parseDouble(arquivo.next()));
                listaArvore.add(newArvore);
            }
            arquivo.close();
            return listaArvore;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public ArrayList<Patio> ImportarPatios(String caminho) throws FileNotFoundException, Exception {
        try {
            ArrayList<Patio> listaPatio = new ArrayList<Patio>();
            listaPatio.clear();
            Scanner arquivo = new Scanner(new FileReader(caminho));
            arquivo.nextLine();
            while (arquivo.hasNext()) {
                Patio newPatio = new Patio();
                newPatio.setId(Integer.parseInt(arquivo.next()));
                newPatio.setNome(arquivo.next());
                newPatio.setX(Double.parseDouble(arquivo.next()));
                newPatio.setY(Double.parseDouble(arquivo.next()));
                listaPatio.add(newPatio);
            }
            arquivo.close();
            return listaPatio;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public double[][] ImportarDistancias(String caminho, int arvores, int patios) throws FileNotFoundException {
        double[][] distancias = new double[arvores][patios];
        Scanner arquivo = new Scanner(new FileReader(caminho));
        arquivo.nextLine();
        while (arquivo.hasNext()) {
            double distancia;
            int id = Integer.parseInt(arquivo.next());
            int codArvore = Integer.parseInt(arquivo.next());
            int codPatio = Integer.parseInt(arquivo.next());
            distancias[codArvore - 1][codPatio - 1] = distancia = Double.parseDouble(arquivo.next());
        }
        arquivo.close();
        return distancias;
    }

    public double menorDistancia(ArrayList<Arvore> ListaArvore) {
        if (ListaArvore.size() > 0) {
            double menorY = 0.0;
            for (Arvore fuste : ListaArvore) {
                if (!(fuste.getY() < menorY) && menorY != 0.0) continue;
                menorY = fuste.getY();
            }
            return menorY;
        }
        return -1.0;
    }

    public double menorDistancia(ArrayList<Arvore> ListaArvore, int qtdeArvores) {
        if (qtdeArvores > 0) {
            double menorY = 0.0;
            for (Arvore fuste : ListaArvore) {
                if (!(fuste.getY() < menorY) && menorY != 0.0) continue;
                menorY = fuste.getY();
            }
            return menorY;
        }
        return -1.0;
    }

    public double[][] CalculaDistancia(ArrayList<Arvore> listaArvore, ArrayList<Patio> listaPatio, int nArvores, int nPatios) {
        double[][] distancias = new double[nArvores][nPatios];
        int i = 0;
        for (Arvore arv : listaArvore) {
            for (int j = 0; j < nPatios; ++j) {
                double distancia;
                Patio patio = listaPatio.get(j);
                distancias[i][j] = distancia = Math.sqrt(Math.pow(arv.getX() - patio.getX(), 2.0) + Math.pow(arv.getY() - patio.getY(), 2.0));
            }
            ++i;
        }
        return distancias;
    }

    public double[][] CalculaDistanciaPatios(ArrayList<Patio> listaPatio, int nPatios) {
        double[][] distancias = new double[nPatios][nPatios];
        int i = 0;
        for (Patio p1 : listaPatio) {
            for (int j = 0; j < nPatios; ++j) {
                double distancia;
                Patio p2 = listaPatio.get(j);
                distancias[i][j] = distancia = Math.sqrt(Math.pow(p1.getX() - p2.getX(), 2.0) + Math.pow(p1.getY() - p2.getY(), 2.0));
            }
            ++i;
        }
        return distancias;
    }

    public int[][] OrdenaDistanciaPatioArvores(Instancia instancia) {
        double[] distanciasOrder = new double[instancia.getQtdeArvores()];
        int[][] arvoresOrder = new int[instancia.getQtdePatios()][instancia.getQtdeArvores()];
        for (int i = 0; i < instancia.getQtdePatios(); ++i) {
            for (int j = 0; j < instancia.getQtdeArvores(); ++j) {
                distanciasOrder[j] = instancia.getDistancias()[j][i];
                arvoresOrder[i][j] = j;
            }
            this.quickSort(distanciasOrder, arvoresOrder[i], 0, instancia.getQtdeArvores() - 1);
        }
        return arvoresOrder;
    }

    public int[][] OrdenaDistanciaPatioPatios(Instancia instancia) {
        double[] distanciasOrder = new double[instancia.getQtdePatios()];
        int[][] patiosOrder = new int[instancia.getQtdePatios()][instancia.getQtdePatios()];
        for (int i = 0; i < instancia.getQtdePatios(); ++i) {
            for (int j = 0; j < instancia.getQtdePatios(); ++j) {
                distanciasOrder[j] = instancia.getDistanciasPatios()[i][j];
                patiosOrder[i][j] = j;
            }
            this.quickSort(distanciasOrder, patiosOrder[i], 0, instancia.getQtdePatios() - 1);
        }
        return patiosOrder;
    }

    public int[][] OrdenaDistanciaArvorePatios(Instancia instancia) {
        double[] distanciasOrder = new double[instancia.getQtdePatios()];
        int[][] patiosOrder = new int[instancia.getQtdeArvores()][instancia.getQtdePatios()];
        for (int i = 0; i < instancia.getQtdeArvores(); ++i) {
            for (int j = 0; j < instancia.getQtdePatios(); ++j) {
                distanciasOrder[j] = instancia.getDistancias()[i][j];
                patiosOrder[i][j] = j;
            }
            this.quickSort(distanciasOrder, patiosOrder[i], 0, instancia.getQtdePatios() - 1);
        }
        return patiosOrder;
    }

    private void quickSort(double[] v, int[] vInd, int esquerda, int direita) {
        int esq = esquerda;
        int dir = direita;
        double pivo = v[(esq + dir) / 2];
        while (esq <= dir) {
            while (v[esq] < pivo) {
                ++esq;
            }
            while (v[dir] > pivo) {
                --dir;
            }
            if (esq > dir) continue;
            double troca = v[esq];
            v[esq] = v[dir];
            v[dir] = troca;
            int elemento = vInd[esq];
            vInd[esq] = vInd[dir];
            vInd[dir] = elemento;
            ++esq;
            --dir;
        }
        if (dir > esquerda) {
            this.quickSort(v, vInd, esquerda, dir);
        }
        if (esq < direita) {
            this.quickSort(v, vInd, esq, direita);
        }
    }

    public class ResultadoDistancia {
        private double distancia;
        private boolean viavel;

        public double getDistancia() {
            return this.distancia;
        }

        public void setDistancia(double distancia) {
            this.distancia = distancia;
        }

        public boolean isViavel() {
            return this.viavel;
        }

        public void setViavel(boolean viavel) {
            this.viavel = viavel;
        }
    }
}

