/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Arvore;
import classes.Instancia;
import classes.Patio;
import classes.Solucao;

public class FO {
    private int[] pontosSel;

    private void inicializaSel(int quantidade) {
        this.pontosSel = new int[quantidade];
        for (int i = 0; i < quantidade; ++i) {
            this.pontosSel[i] = 0;
        }
    }

    private void marcaSel(int ponto) {
        this.pontosSel[ponto] = 1;
    }

    private void desmarcaSel(int ponto) {
        this.pontosSel[ponto] = 0;
    }

    private boolean getSel(int ponto) {
        return this.pontosSel[ponto] == 1;
    }

    private int getFree(int quantidade) {
        for (int i = 0; i < quantidade; ++i) {
            if (this.pontosSel[i] != 0) continue;
            return i;
        }
        return -1;
    }

    private void marcaPontosSel(Solucao sol) {
        for (Patio patio : sol.getPatios()) {
            this.pontosSel[patio.getId() - 1] = 1;
        }
    }

    public Solucao calculaFOSR(Instancia instancia, Solucao solucao) throws Exception {
        try {
            Solucao sol = new Solucao();
            sol.setPatios(solucao.getPatios());
            double distanciaTotal = 0.0;
            for (Patio patio : sol.getPatios()) {
                double distanciaPatio = 0.0;
                for (Arvore arvore : patio.getArvores()) {
                    double distancia = instancia.getDistancias()[arvore.getId() - 1][patio.getId() - 1];
                    distanciaPatio += distancia;
                }
                patio.setFO(distanciaPatio / (double)patio.getArvores().size());
                distanciaTotal += distanciaPatio;
            }
            sol.setViavel(true);
            sol.setFO(distanciaTotal);
            return sol;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Solucao calculaFO(Instancia instancia, Solucao solucao) throws Exception {
        try {
            Solucao sol = new Solucao();
            sol.setPatios(solucao.getPatios());
            double distanciaTotal = 0.0;
            double diferencaDistancia = 0.0;
            double diferencaVolume = 0.0;
            double volumeMaximo = instancia.getCapacidadePatio() + instancia.getCapacidadePatio() * instancia.getFlexCapacidade() / 100.0;
            double distanciaMaxima = instancia.getDistanciaMaximaArraste() + instancia.getDistanciaMaximaArraste() * instancia.getFlexDistancia() / 100.0;
            for (Patio patio : sol.getPatios()) {
                double distanciaPatio = 0.0;
                patio.getArvoresInviaveis().clear();
                for (Arvore arvore : patio.getArvores()) {
                    double distancia = instancia.getDistancias()[arvore.getId() - 1][patio.getId() - 1];
                    if (distancia > distanciaMaxima) {
                        diferencaDistancia += distancia - distanciaMaxima;
                        patio.addArvoreInviavel(arvore);
                    }
                    distanciaPatio += distancia;
                }
                patio.setFO(distanciaPatio / (double)patio.getArvores().size());
                distanciaTotal += distanciaPatio;
                if (!(patio.getVolume() > volumeMaximo)) continue;
                diferencaVolume += patio.getVolume() - volumeMaximo;
            }
            sol.setViavel(diferencaDistancia + diferencaVolume == 0.0);
            sol.setFO(distanciaTotal += instancia.getPenalizacao() * (diferencaDistancia + diferencaVolume));
            return sol;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Solucao alocaArvoresPatio(Instancia instancia, Solucao solucao) throws Exception {
        try {
            int j;
            this.inicializaSel(instancia.getQtdeArvores());
            Solucao sol = new Solucao();
            for (Patio p : solucao.getPatios()) {
                p.getArvores().clear();
                p.getArvoresInviaveis().clear();
                sol.addPatio(p);
            }
            double volumeMaximo = instancia.getCapacidadePatio() + instancia.getCapacidadePatio() * instancia.getFlexCapacidade() / 100.0;
            double distanciaMaxima = instancia.getDistanciaMaximaArraste() + instancia.getDistanciaMaximaArraste() * instancia.getFlexDistancia() / 100.0;
            for (Patio patio : sol.getPatios()) {
                j = 0;
                patio.setVolume(0.0);
                while (patio.getVolume() < instancia.getCapacidadePatio() && j < instancia.getQtdeArvores()) {
                    double distancia;
                    Arvore arv;
                    do {
                        arv = instancia.getListaArvore().get(instancia.getOrdemDistanciasPatioArvores()[patio.getId() - 1][j]);
                        distancia = instancia.getDistancias()[arv.getId() - 1][patio.getId() - 1];
                    } while (this.getSel(arv.getId() - 1) && ++j < instancia.getQtdeArvores());
                    if (!(patio.getVolume() + arv.getVolumeEq() < volumeMaximo) || !(distancia <= distanciaMaxima)) continue;
                    patio.setVolume(patio.getVolume() + arv.getVolumeEq());
                    this.marcaSel(arv.getId() - 1);
                    patio.addArvore(arv);
                }
            }
            for (int i = 0; i < instancia.getQtdeArvores(); ++i) {
                if (this.getSel(i)) continue;
                double distanciaMenor = Double.POSITIVE_INFINITY;
                int pPatio = -1;
                Arvore arv2 = instancia.getListaArvore().get(i);
                j = 0;
                for (Patio patio : sol.getPatios()) {
                    double distancia = instancia.getDistancias()[arv2.getId() - 1][patio.getId() - 1];
                    if (distancia < distanciaMenor && patio.getVolume() + arv2.getVolumeEq() < volumeMaximo) {
                        distanciaMenor = distancia;
                        pPatio = j;
                    }
                    ++j;
                }
                if (pPatio == -1) continue;
                sol.getPatios().get(pPatio).setVolume(sol.getPatios().get(pPatio).getVolume() + arv2.getVolumeEq());
                this.marcaSel(arv2.getId() - 1);
                sol.getPatios().get(pPatio).addArvore(arv2);
            }
            return sol;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Solucao alocaArvoresPatioSR(Instancia instancia, Solucao solucao) throws Exception {
        try {
            Solucao sol = new Solucao();
            for (Patio p : solucao.getPatios()) {
                p.getArvores().clear();
                p.getArvoresInviaveis().clear();
                sol.addPatio(p);
            }
            for (int i = 0; i < instancia.getQtdeArvores(); ++i) {
                double distanciaMenor = Double.POSITIVE_INFINITY;
                int pPatio = -1;
                Arvore arv = instancia.getListaArvore().get(i);
                int j = 0;
                for (Patio patio : sol.getPatios()) {
                    double distancia = instancia.getDistancias()[arv.getId() - 1][patio.getId() - 1];
                    if (distancia < distanciaMenor) {
                        distanciaMenor = distancia;
                        pPatio = j;
                    }
                    ++j;
                }
                if (pPatio == -1) continue;
                sol.getPatios().get(pPatio).setVolume(sol.getPatios().get(pPatio).getVolume() + arv.getVolumeEq());
                sol.getPatios().get(pPatio).addArvore(arv);
            }
            return sol;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Solucao alocaArvoresPatioV2(Instancia instancia, Solucao solucao) throws Exception {
        try {
            int j;
            this.inicializaSel(instancia.getQtdeArvores());
            Solucao sol = new Solucao();
            for (Patio p : solucao.getPatios()) {
                p.getArvores().clear();
                p.getArvoresInviaveis().clear();
                sol.addPatio(p);
            }
            double capacidadePatio = instancia.getCapacidadePatio() - instancia.getCapacidadePatio() * 0.2;
            double volumeMaximoInicial = capacidadePatio + capacidadePatio * instancia.getFlexCapacidade() / 100.0;
            double volumeMaximo = instancia.getCapacidadePatio() + instancia.getCapacidadePatio() * instancia.getFlexCapacidade() / 100.0;
            double distanciaMaxima = instancia.getDistanciaMaximaArraste() + instancia.getDistanciaMaximaArraste() * instancia.getFlexDistancia() / 100.0;
            for (Patio patio : sol.getPatios()) {
                j = 0;
                patio.setVolume(0.0);
                while (patio.getVolume() < capacidadePatio && j < instancia.getQtdeArvores()) {
                    double distancia;
                    Arvore arv;
                    do {
                        arv = instancia.getListaArvore().get(instancia.getOrdemDistanciasPatioArvores()[patio.getId() - 1][j]);
                        distancia = instancia.getDistancias()[arv.getId() - 1][patio.getId() - 1];
                    } while (this.getSel(arv.getId() - 1) && ++j < instancia.getQtdeArvores());
                    if (!(patio.getVolume() + arv.getVolumeEq() < volumeMaximoInicial) || !(distancia <= distanciaMaxima)) continue;
                    patio.setVolume(patio.getVolume() + arv.getVolumeEq());
                    this.marcaSel(arv.getId() - 1);
                    patio.addArvore(arv);
                }
            }
            for (int i = 0; i < instancia.getQtdeArvores(); ++i) {
                if (this.getSel(i)) continue;
                double distanciaMenor = Double.POSITIVE_INFINITY;
                int pPatio = -1;
                Arvore arv2 = instancia.getListaArvore().get(i);
                j = 0;
                for (Patio patio : sol.getPatios()) {
                    double distancia = instancia.getDistancias()[arv2.getId() - 1][patio.getId() - 1];
                    if (distancia < distanciaMenor && patio.getVolume() + arv2.getVolumeEq() < volumeMaximo) {
                        distanciaMenor = distancia;
                        pPatio = j;
                    }
                    ++j;
                }
                if (pPatio == -1) continue;
                sol.getPatios().get(pPatio).setVolume(sol.getPatios().get(pPatio).getVolume() + arv2.getVolumeEq());
                this.marcaSel(arv2.getId() - 1);
                sol.getPatios().get(pPatio).addArvore(arv2);
            }
            return sol;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Solucao alocaArvoresPatioV3(Instancia instancia, Solucao solucao) throws Exception {
        try {
            int j;
            this.inicializaSel(instancia.getQtdeArvores());
            Solucao sol = new Solucao();
            for (Patio p : solucao.getPatios()) {
                p.getArvores().clear();
                p.getArvoresInviaveis().clear();
                p.setVolume(0.0);
                sol.addPatio(p);
            }
            double volumeMaximo = instancia.getCapacidadePatio() + instancia.getCapacidadePatio() * instancia.getFlexCapacidade() / 100.0;
            double distanciaMaxima = instancia.getDistanciaMaximaArraste() + instancia.getDistanciaMaximaArraste() * instancia.getFlexDistancia() / 100.0;
            int Referencia = 0;
            boolean continua = true;
            while (Referencia < instancia.getQtdeArvores() && continua) {
                continua = false;
                for (Patio patio : sol.getPatios()) {
                    j = Referencia;
                    boolean arvSelecionada = false;
                    boolean inviavel = false;
                    while (!(arvSelecionada && inviavel || j >= instancia.getQtdeArvores())) {
                        double distancia;
                        Arvore arv;
                        do {
                            arv = instancia.getListaArvore().get(instancia.getOrdemDistanciasPatioArvores()[patio.getId() - 1][j]);
                            distancia = instancia.getDistancias()[arv.getId() - 1][patio.getId() - 1];
                        } while (this.getSel(arv.getId() - 1) && ++j < instancia.getQtdeArvores());
                        if (j >= instancia.getQtdeArvores()) {
                            inviavel = true;
                            continue;
                        }
                        if (patio.getVolume() + arv.getVolumeEq() < volumeMaximo && distancia <= distanciaMaxima) {
                            patio.setVolume(patio.getVolume() + arv.getVolumeEq());
                            this.marcaSel(arv.getId() - 1);
                            patio.addArvore(arv);
                            continua = true;
                            arvSelecionada = true;
                            continue;
                        }
                        if (!(patio.getVolume() + arv.getVolumeEq() > volumeMaximo) && !(distancia > distanciaMaxima)) continue;
                        inviavel = true;
                    }
                }
                Referencia = this.getFree(instancia.getQtdeArvores());
            }
            if (Referencia != -1) {
                for (int i = 0; i < instancia.getQtdeArvores(); ++i) {
                    if (this.getSel(i)) continue;
                    double distanciaMenor = Double.POSITIVE_INFINITY;
                    int pPatio = -1;
                    Arvore arv2 = instancia.getListaArvore().get(i);
                    j = 0;
                    for (Patio patio : sol.getPatios()) {
                        double distancia = instancia.getDistancias()[arv2.getId() - 1][patio.getId() - 1];
                        if (distancia < distanciaMenor && patio.getVolume() + arv2.getVolumeEq() < volumeMaximo) {
                            distanciaMenor = distancia;
                            pPatio = j;
                        }
                        ++j;
                    }
                    if (pPatio == -1) continue;
                    sol.getPatios().get(pPatio).setVolume(sol.getPatios().get(pPatio).getVolume() + arv2.getVolumeEq());
                    this.marcaSel(arv2.getId() - 1);
                    sol.getPatios().get(pPatio).addArvore(arv2);
                }
            }
            return sol;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Solucao realocarArvoresPatio(Instancia instancia, Solucao solucao) throws Exception {
        try {
            Solucao sol = new Solucao();
            sol.setPatios(solucao.getPatios());
            double volumeMaximo = instancia.getCapacidadePatio() + instancia.getCapacidadePatio() * instancia.getFlexCapacidade() / 100.0;
            Patio pMaisProximo = null;
            int iPatio = 0;
            for (int i = 0; i < sol.getPatios().size(); ++i) {
                Patio patio = sol.getPatios().get(i);
                for (int j = 0; j < patio.getArvoresInviaveis().size(); ++j) {
                    double distancia;
                    double distanciaMenor = Double.POSITIVE_INFINITY;
                    Arvore arvInviavel = new Arvore(patio.getArvoresInviaveis().get(j));
                    int iInviavel = -1;
                    for (int n = 0; n < sol.getPatios().get(i).getArvores().size(); ++n) {
                        if (sol.getPatios().get(i).getArvores().get(n).getId() != arvInviavel.getId()) continue;
                        iInviavel = n;
                    }
                    if (iInviavel == -1) continue;
                    for (int k = 0; k < sol.getPatios().size(); ++k) {
                        Patio patioAloc = sol.getPatios().get(k);
                        distancia = instancia.getDistancias()[arvInviavel.getId() - 1][patioAloc.getId() - 1];
                        if (!(distancia < distanciaMenor)) continue;
                        distanciaMenor = distancia;
                        pMaisProximo = new Patio(patioAloc);
                        iPatio = k;
                    }
                    if (pMaisProximo.getVolume() + arvInviavel.getVolumeEq() < volumeMaximo) {
                        pMaisProximo.addArvore(arvInviavel);
                        pMaisProximo.setVolume(pMaisProximo.getVolume() + arvInviavel.getVolumeEq());
                        patio.setVolume(patio.getVolume() - arvInviavel.getVolumeEq());
                        continue;
                    }
                    int iTroca = 0;
                    distanciaMenor = Double.POSITIVE_INFINITY;
                    Arvore arvTroca = null;
                    for (int m = 0; m < sol.getPatios().get(iPatio).getArvores().size(); ++m) {
                        Arvore arvJ = sol.getPatios().get(iPatio).getArvores().get(m);
                        distancia = instancia.getDistancias()[arvJ.getId() - 1][patio.getId() - 1];
                        if (!(distancia < distanciaMenor)) continue;
                        distanciaMenor = distancia;
                        arvTroca = new Arvore(arvJ);
                        iTroca = m;
                    }
                    sol.getPatios().get(i).setVolume(sol.getPatios().get(i).getVolume() - arvInviavel.getVolumeEq() + arvTroca.getVolumeEq());
                    sol.getPatios().get(i).getArvores().set(iInviavel, arvTroca);
                    sol.getPatios().get(iPatio).setVolume(sol.getPatios().get(iPatio).getVolume() + arvInviavel.getVolumeEq() - arvTroca.getVolumeEq());
                    sol.getPatios().get(iPatio).getArvores().set(iTroca, arvInviavel);
                }
            }
            if ((sol = this.calculaFO(instancia, sol)).getFO() < solucao.getFO()) {
                return sol;
            }
            return solucao;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    public Solucao realocarPatios(Instancia instancia, Solucao solucao) throws Exception {
        try {
            this.inicializaSel(instancia.getQtdePatios());
            Solucao sol = new Solucao();
            sol = sol.aceita(solucao);
            this.marcaPontosSel(sol);
            double oldFO = sol.getFO();
            for (int i = 0; i < sol.getPatios().size(); ++i) {
                int oldPatio;
                boolean avaliar = false;
                Patio patio = sol.getPatios().get(i);
                for (Arvore arvore : patio.getArvores()) {
                    double distancia = instancia.getDistancias()[arvore.getId() - 1][patio.getId() - 1];
                    if (!(distancia > patio.getFO() + patio.getFO() * 0.2) && !(distancia < patio.getFO() - patio.getFO() * 0.2)) continue;
                    avaliar = true;
                    break;
                }
                if (!avaliar) continue;
                int melhorPatio = oldPatio = patio.getId();
                for (int j = 0; j < instancia.getQtdePatios(); ++j) {
                    if (this.getSel(j)) continue;
                    Patio newPatio = new Patio(instancia.getListaPatio().get(j));
                    newPatio.setArvores(patio.getArvores());
                    sol.getPatios().set(i, newPatio);
                    sol = this.calculaFO(instancia, sol);
                    if (!(sol.getFO() < oldFO)) continue;
                    melhorPatio = j;
                    oldFO = sol.getFO();
                }
                sol.getPatios().set(i, instancia.getListaPatio().get(melhorPatio));
                sol = this.calculaFO(instancia, sol);
                this.desmarcaSel(oldPatio);
                this.marcaSel(melhorPatio);
            }
            return sol;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }
}

